@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property currentSigningKeyLength [Easy DKIM] The key length of the DKIM key pair in use.
 * @property domainSigningPrivateKey [Bring Your Own DKIM] A private key that's used to generate a DKIM signature. The private key must use 1024 or 2048-bit RSA encryption, and must be encoded using base64 encoding.
 * > **NOTE:** You have to delete the first and last lines ('-----BEGIN PRIVATE KEY-----' and '-----END PRIVATE KEY-----', respectively) of the generated private key. Additionally, you have to remove the line breaks in the generated private key. The resulting value is a string of characters with no spaces or line breaks.
 * @property domainSigningSelector [Bring Your Own DKIM] A string that's used to identify a public key in the DNS configuration for a domain.
 * @property lastKeyGenerationTimestamp [Easy DKIM] The last time a key pair was generated for this identity.
 * @property nextSigningKeyLength [Easy DKIM] The key length of the future DKIM key pair to be generated. This can be changed at most once per day. Valid values: `RSA_1024_BIT`, `RSA_2048_BIT`.
 * @property signingAttributesOrigin A string that indicates how DKIM was configured for the identity. `AWS_SES` indicates that DKIM was configured for the identity by using Easy DKIM. `EXTERNAL` indicates that DKIM was configured for the identity by using Bring Your Own DKIM (BYODKIM).
 * @property status Describes whether or not Amazon SES has successfully located the DKIM records in the DNS records for the domain. See the [AWS SES API v2 Reference](https://docs.aws.amazon.com/ses/latest/APIReference-V2/API_DkimAttributes.html#SES-Type-DkimAttributes-Status) for supported statuses.
 * @property tokens If you used Easy DKIM to configure DKIM authentication for the domain, then this object contains a set of unique strings that you use to create a set of CNAME records that you add to the DNS configuration for your domain. When Amazon SES detects these records in the DNS configuration for your domain, the DKIM authentication process is complete. If you configured DKIM authentication for the domain by providing your own public-private key pair, then this object contains the selector for the public key.
 */
public data class EmailIdentityDkimSigningAttributes(
    public val currentSigningKeyLength: String? = null,
    public val domainSigningPrivateKey: String? = null,
    public val domainSigningSelector: String? = null,
    public val lastKeyGenerationTimestamp: String? = null,
    public val nextSigningKeyLength: String? = null,
    public val signingAttributesOrigin: String? = null,
    public val status: String? = null,
    public val tokens: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sesv2.outputs.EmailIdentityDkimSigningAttributes):
            EmailIdentityDkimSigningAttributes = EmailIdentityDkimSigningAttributes(
            currentSigningKeyLength = javaType.currentSigningKeyLength().map({ args0 -> args0 }).orElse(null),
            domainSigningPrivateKey = javaType.domainSigningPrivateKey().map({ args0 -> args0 }).orElse(null),
            domainSigningSelector = javaType.domainSigningSelector().map({ args0 -> args0 }).orElse(null),
            lastKeyGenerationTimestamp = javaType.lastKeyGenerationTimestamp().map({ args0 ->
                args0
            }).orElse(null),
            nextSigningKeyLength = javaType.nextSigningKeyLength().map({ args0 -> args0 }).orElse(null),
            signingAttributesOrigin = javaType.signingAttributesOrigin().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            tokens = javaType.tokens().map({ args0 -> args0 }),
        )
    }
}
