@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property lastFreshStart The date and time (in Unix time) when the reputation metrics were last given a fresh start.
 * @property reputationMetricsEnabled Specifies whether tracking of reputation metrics is enabled.
 */
public data class GetConfigurationSetReputationOption(
    public val lastFreshStart: String,
    public val reputationMetricsEnabled: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sesv2.outputs.GetConfigurationSetReputationOption):
            GetConfigurationSetReputationOption = GetConfigurationSetReputationOption(
            lastFreshStart = javaType.lastFreshStart(),
            reputationMetricsEnabled = javaType.reputationMetricsEnabled(),
        )
    }
}
