@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getConfigurationSet.
 * @property arn
 * @property configurationSetName
 * @property deliveryOptions An object that defines the dedicated IP pool that is used to send emails that you send using the configuration set.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property reputationOptions An object that defines whether or not Amazon SES collects reputation metrics for the emails that you send that use the configuration set.
 * @property sendingOptions An object that defines whether or not Amazon SES can send email that you send using the configuration set.
 * @property suppressionOptions An object that contains information about the suppression list preferences for your account.
 * @property tags Key-value map of resource tags for the container recipe.
 * @property trackingOptions An object that defines the open and click tracking options for emails that you send using the configuration set.
 * @property vdmOptions An object that contains information about the VDM preferences for your configuration set.
 */
public data class GetConfigurationSetResult(
    public val arn: String,
    public val configurationSetName: String,
    public val deliveryOptions: List<GetConfigurationSetDeliveryOption>,
    public val id: String,
    public val reputationOptions: List<GetConfigurationSetReputationOption>,
    public val sendingOptions: List<GetConfigurationSetSendingOption>,
    public val suppressionOptions: List<GetConfigurationSetSuppressionOption>,
    public val tags: Map<String, String>,
    public val trackingOptions: List<GetConfigurationSetTrackingOption>,
    public val vdmOptions: List<GetConfigurationSetVdmOption>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sesv2.outputs.GetConfigurationSetResult):
            GetConfigurationSetResult = GetConfigurationSetResult(
            arn = javaType.arn(),
            configurationSetName = javaType.configurationSetName(),
            deliveryOptions = javaType.deliveryOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sesv2.kotlin.outputs.GetConfigurationSetDeliveryOption.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            reputationOptions = javaType.reputationOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sesv2.kotlin.outputs.GetConfigurationSetReputationOption.Companion.toKotlin(args0)
                })
            }),
            sendingOptions = javaType.sendingOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sesv2.kotlin.outputs.GetConfigurationSetSendingOption.Companion.toKotlin(args0)
                })
            }),
            suppressionOptions = javaType.suppressionOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sesv2.kotlin.outputs.GetConfigurationSetSuppressionOption.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            trackingOptions = javaType.trackingOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sesv2.kotlin.outputs.GetConfigurationSetTrackingOption.Companion.toKotlin(args0)
                })
            }),
            vdmOptions = javaType.vdmOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sesv2.kotlin.outputs.GetConfigurationSetVdmOption.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
