@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property ip IPv4 address.
 * @property warmupPercentage Indicates how complete the dedicated IP warm-up process is. When this value equals `1`, the address has completed the warm-up process and is ready for use.
 * @property warmupStatus The warm-up status of a dedicated IP address. Valid values: `IN_PROGRESS`, `DONE`.
 */
public data class GetDedicatedIpPoolDedicatedIp(
    public val ip: String,
    public val warmupPercentage: Int,
    public val warmupStatus: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sesv2.outputs.GetDedicatedIpPoolDedicatedIp):
            GetDedicatedIpPoolDedicatedIp = GetDedicatedIpPoolDedicatedIp(
            ip = javaType.ip(),
            warmupPercentage = javaType.warmupPercentage(),
            warmupStatus = javaType.warmupStatus(),
        )
    }
}
