@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getEmailIdentity.
 * @property arn ARN of the Email Identity.
 * @property configurationSetName
 * @property dkimSigningAttributes A list of objects that contains at most one element with information about the private key and selector that you want to use to configure DKIM for the identity for Bring Your Own DKIM (BYODKIM) for the identity, or, configures the key length to be used for Easy DKIM.
 * @property emailIdentity
 * @property id The provider-assigned unique ID for this managed resource.
 * @property identityType The email identity type. Valid values: `EMAIL_ADDRESS`, `DOMAIN`.
 * @property tags Key-value mapping of resource tags.
 * @property verifiedForSendingStatus Specifies whether or not the identity is verified.
 */
public data class GetEmailIdentityResult(
    public val arn: String,
    public val configurationSetName: String,
    public val dkimSigningAttributes: List<GetEmailIdentityDkimSigningAttribute>,
    public val emailIdentity: String,
    public val id: String,
    public val identityType: String,
    public val tags: Map<String, String>,
    public val verifiedForSendingStatus: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sesv2.outputs.GetEmailIdentityResult):
            GetEmailIdentityResult = GetEmailIdentityResult(
            arn = javaType.arn(),
            configurationSetName = javaType.configurationSetName(),
            dkimSigningAttributes = javaType.dkimSigningAttributes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sesv2.kotlin.outputs.GetEmailIdentityDkimSigningAttribute.Companion.toKotlin(args0)
                })
            }),
            emailIdentity = javaType.emailIdentity(),
            id = javaType.id(),
            identityType = javaType.identityType(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            verifiedForSendingStatus = javaType.verifiedForSendingStatus(),
        )
    }
}
