@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sfn.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Activity].
 */
@PulumiTagMarker
public class ActivityResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ActivityArgs = ActivityArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ActivityArgsBuilder.() -> Unit) {
        val builder = ActivityArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Activity {
        val builtJavaResource = com.pulumi.aws.sfn.Activity(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Activity(builtJavaResource)
    }
}

/**
 * Provides a Step Function Activity resource
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sfn.Activity;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sfnActivity = new Activity("sfnActivity");
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import activities using the `arn`. For example:
 * ```sh
 *  $ pulumi import aws:sfn/activity:Activity foo arn:aws:states:eu-west-1:123456789098:activity:bar
 * ```
 *
 */
public class Activity internal constructor(
    override val javaResource: com.pulumi.aws.sfn.Activity,
) : KotlinCustomResource(javaResource, ActivityMapper) {
    /**
     * The date the activity was created.
     */
    public val creationDate: Output<String>
        get() = javaResource.creationDate().applyValue({ args0 -> args0 })

    /**
     * The name of the activity to create.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ActivityMapper : ResourceMapper<Activity> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sfn.Activity::class == javaResource::class

    override fun map(javaResource: Resource): Activity = Activity(
        javaResource as
            com.pulumi.aws.sfn.Activity,
    )
}

/**
 * @see [Activity].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Activity].
 */
public suspend fun activity(name: String, block: suspend ActivityResourceBuilder.() -> Unit):
    Activity {
    val builder = ActivityResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Activity].
 * @param name The _unique_ name of the resulting resource.
 */
public fun activity(name: String): Activity {
    val builder = ActivityResourceBuilder()
    builder.name(name)
    return builder.build()
}
