@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sfn.kotlin

import com.pulumi.aws.sfn.kotlin.outputs.AliasRoutingConfiguration
import com.pulumi.aws.sfn.kotlin.outputs.AliasRoutingConfiguration.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [Alias].
 */
@PulumiTagMarker
public class AliasResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AliasArgs = AliasArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AliasArgsBuilder.() -> Unit) {
        val builder = AliasArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Alias {
        val builtJavaResource = com.pulumi.aws.sfn.Alias(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Alias(builtJavaResource)
    }
}

/**
 * Provides a Step Function State Machine Alias.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sfn.Alias;
 * import com.pulumi.aws.sfn.AliasArgs;
 * import com.pulumi.aws.sfn.inputs.AliasRoutingConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sfnAlias = new Alias("sfnAlias", AliasArgs.builder()
 *             .routingConfigurations(AliasRoutingConfigurationArgs.builder()
 *                 .stateMachineVersionArn(aws_sfn_state_machine.sfn_test().state_machine_version_arn())
 *                 .weight(100)
 *                 .build())
 *             .build());
 *         var mySfnAlias = new Alias("mySfnAlias", AliasArgs.builder()
 *             .routingConfigurations(
 *                 AliasRoutingConfigurationArgs.builder()
 *                     .stateMachineVersionArn("arn:aws:states:us-east-1:12345:stateMachine:demo:3")
 *                     .weight(50)
 *                     .build(),
 *                 AliasRoutingConfigurationArgs.builder()
 *                     .stateMachineVersionArn("arn:aws:states:us-east-1:12345:stateMachine:demo:2")
 *                     .weight(50)
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SFN (Step Functions) Alias using the `arn`. For example:
 * ```sh
 *  $ pulumi import aws:sfn/alias:Alias foo arn:aws:states:us-east-1:123456789098:stateMachine:myStateMachine:foo
 * ```
 *
 */
public class Alias internal constructor(
    override val javaResource: com.pulumi.aws.sfn.Alias,
) : KotlinCustomResource(javaResource, AliasMapper) {
    /**
     * The Amazon Resource Name (ARN) identifying your state machine alias.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The date the state machine alias was created.
     */
    public val creationDate: Output<String>
        get() = javaResource.creationDate().applyValue({ args0 -> args0 })

    /**
     * Description of the alias.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name for the alias you are creating.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The StateMachine alias' route configuration settings. Fields documented below
     */
    public val routingConfigurations: Output<List<AliasRoutingConfiguration>>
        get() = javaResource.routingConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            })
        })
}

public object AliasMapper : ResourceMapper<Alias> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sfn.Alias::class == javaResource::class

    override fun map(javaResource: Resource): Alias = Alias(javaResource as com.pulumi.aws.sfn.Alias)
}

/**
 * @see [Alias].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Alias].
 */
public suspend fun alias(name: String, block: suspend AliasResourceBuilder.() -> Unit): Alias {
    val builder = AliasResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Alias].
 * @param name The _unique_ name of the resulting resource.
 */
public fun alias(name: String): Alias {
    val builder = AliasResourceBuilder()
    builder.name(name)
    return builder.build()
}
