@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sfn.kotlin

import com.pulumi.aws.sfn.AliasArgs.builder
import com.pulumi.aws.sfn.kotlin.inputs.AliasRoutingConfigurationArgs
import com.pulumi.aws.sfn.kotlin.inputs.AliasRoutingConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Step Function State Machine Alias.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sfn.Alias;
 * import com.pulumi.aws.sfn.AliasArgs;
 * import com.pulumi.aws.sfn.inputs.AliasRoutingConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sfnAlias = new Alias("sfnAlias", AliasArgs.builder()
 *             .routingConfigurations(AliasRoutingConfigurationArgs.builder()
 *                 .stateMachineVersionArn(aws_sfn_state_machine.sfn_test().state_machine_version_arn())
 *                 .weight(100)
 *                 .build())
 *             .build());
 *         var mySfnAlias = new Alias("mySfnAlias", AliasArgs.builder()
 *             .routingConfigurations(
 *                 AliasRoutingConfigurationArgs.builder()
 *                     .stateMachineVersionArn("arn:aws:states:us-east-1:12345:stateMachine:demo:3")
 *                     .weight(50)
 *                     .build(),
 *                 AliasRoutingConfigurationArgs.builder()
 *                     .stateMachineVersionArn("arn:aws:states:us-east-1:12345:stateMachine:demo:2")
 *                     .weight(50)
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SFN (Step Functions) Alias using the `arn`. For example:
 * ```sh
 *  $ pulumi import aws:sfn/alias:Alias foo arn:aws:states:us-east-1:123456789098:stateMachine:myStateMachine:foo
 * ```
 * @property description Description of the alias.
 * @property name Name for the alias you are creating.
 * @property routingConfigurations The StateMachine alias' route configuration settings. Fields documented below
 */
public data class AliasArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val routingConfigurations: Output<List<AliasRoutingConfigurationArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.sfn.AliasArgs> {
    override fun toJava(): com.pulumi.aws.sfn.AliasArgs = com.pulumi.aws.sfn.AliasArgs.builder()
        .description(description?.applyValue({ args0 -> args0 }))
        .name(name?.applyValue({ args0 -> args0 }))
        .routingConfigurations(
            routingConfigurations?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                })
            }),
        ).build()
}

/**
 * Builder for [AliasArgs].
 */
@PulumiTagMarker
public class AliasArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var routingConfigurations: Output<List<AliasRoutingConfigurationArgs>>? = null

    /**
     * @param value Description of the alias.
     */
    @JvmName("finsacdyexlvmjjh")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name for the alias you are creating.
     */
    @JvmName("klavfrwtjumtjhgu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The StateMachine alias' route configuration settings. Fields documented below
     */
    @JvmName("xcdqhwaobnhsbigi")
    public suspend fun routingConfigurations(`value`: Output<List<AliasRoutingConfigurationArgs>>) {
        this.routingConfigurations = value
    }

    @JvmName("ifbvarljcwsxkqcy")
    public suspend fun routingConfigurations(vararg values: Output<AliasRoutingConfigurationArgs>) {
        this.routingConfigurations = Output.all(values.asList())
    }

    /**
     * @param values The StateMachine alias' route configuration settings. Fields documented below
     */
    @JvmName("bewxgrcdjjqsufqg")
    public suspend fun routingConfigurations(values: List<Output<AliasRoutingConfigurationArgs>>) {
        this.routingConfigurations = Output.all(values)
    }

    /**
     * @param value Description of the alias.
     */
    @JvmName("manatbxtkwaompfs")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name for the alias you are creating.
     */
    @JvmName("kbasdeoyfywfgmiu")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The StateMachine alias' route configuration settings. Fields documented below
     */
    @JvmName("mkjqotifjaxjjakb")
    public suspend fun routingConfigurations(`value`: List<AliasRoutingConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routingConfigurations = mapped
    }

    /**
     * @param argument The StateMachine alias' route configuration settings. Fields documented below
     */
    @JvmName("esmpyyxpmdvpvbjk")
    public suspend
    fun routingConfigurations(argument: List<suspend AliasRoutingConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AliasRoutingConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.routingConfigurations = mapped
    }

    /**
     * @param argument The StateMachine alias' route configuration settings. Fields documented below
     */
    @JvmName("pgpnxasfoqwctnxu")
    public suspend fun routingConfigurations(
        vararg
        argument: suspend AliasRoutingConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AliasRoutingConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.routingConfigurations = mapped
    }

    /**
     * @param argument The StateMachine alias' route configuration settings. Fields documented below
     */
    @JvmName("rbqkdiyhyhxlqigm")
    public suspend
    fun routingConfigurations(argument: suspend AliasRoutingConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AliasRoutingConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.routingConfigurations = mapped
    }

    /**
     * @param values The StateMachine alias' route configuration settings. Fields documented below
     */
    @JvmName("kwdaivvposyhlnuv")
    public suspend fun routingConfigurations(vararg values: AliasRoutingConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routingConfigurations = mapped
    }

    internal fun build(): AliasArgs = AliasArgs(
        description = description,
        name = name,
        routingConfigurations = routingConfigurations,
    )
}
