@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sfn.kotlin

import com.pulumi.aws.sfn.SfnFunctions.getActivityPlain
import com.pulumi.aws.sfn.SfnFunctions.getAliasPlain
import com.pulumi.aws.sfn.SfnFunctions.getStateMachinePlain
import com.pulumi.aws.sfn.SfnFunctions.getStateMachineVersionsPlain
import com.pulumi.aws.sfn.kotlin.inputs.GetActivityPlainArgs
import com.pulumi.aws.sfn.kotlin.inputs.GetActivityPlainArgsBuilder
import com.pulumi.aws.sfn.kotlin.inputs.GetAliasPlainArgs
import com.pulumi.aws.sfn.kotlin.inputs.GetAliasPlainArgsBuilder
import com.pulumi.aws.sfn.kotlin.inputs.GetStateMachinePlainArgs
import com.pulumi.aws.sfn.kotlin.inputs.GetStateMachinePlainArgsBuilder
import com.pulumi.aws.sfn.kotlin.inputs.GetStateMachineVersionsPlainArgs
import com.pulumi.aws.sfn.kotlin.inputs.GetStateMachineVersionsPlainArgsBuilder
import com.pulumi.aws.sfn.kotlin.outputs.GetActivityResult
import com.pulumi.aws.sfn.kotlin.outputs.GetAliasResult
import com.pulumi.aws.sfn.kotlin.outputs.GetStateMachineResult
import com.pulumi.aws.sfn.kotlin.outputs.GetStateMachineVersionsResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.sfn.kotlin.outputs.GetActivityResult.Companion.toKotlin as getActivityResultToKotlin
import com.pulumi.aws.sfn.kotlin.outputs.GetAliasResult.Companion.toKotlin as getAliasResultToKotlin
import com.pulumi.aws.sfn.kotlin.outputs.GetStateMachineResult.Companion.toKotlin as getStateMachineResultToKotlin
import com.pulumi.aws.sfn.kotlin.outputs.GetStateMachineVersionsResult.Companion.toKotlin as getStateMachineVersionsResultToKotlin

public object SfnFunctions {
    /**
     * Provides a Step Functions Activity data source
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.sfn.SfnFunctions;
     * import com.pulumi.aws.sfn.inputs.GetActivityArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var sfnActivity = SfnFunctions.getActivity(GetActivityArgs.builder()
     *             .name("my-activity")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getActivity.
     * @return A collection of values returned by getActivity.
     */
    public suspend fun getActivity(argument: GetActivityPlainArgs): GetActivityResult =
        getActivityResultToKotlin(getActivityPlain(argument.toJava()).await())

    /**
     * @see [getActivity].
     * @param arn ARN that identifies the activity.
     * @param name Name that identifies the activity.
     * @return A collection of values returned by getActivity.
     */
    public suspend fun getActivity(arn: String? = null, name: String? = null): GetActivityResult {
        val argument = GetActivityPlainArgs(
            arn = arn,
            name = name,
        )
        return getActivityResultToKotlin(getActivityPlain(argument.toJava()).await())
    }

    /**
     * @see [getActivity].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;sfn&#46;kotlin&#46;inputs&#46;GetActivityPlainArgs].
     * @return A collection of values returned by getActivity.
     */
    public suspend fun getActivity(argument: suspend GetActivityPlainArgsBuilder.() -> Unit):
        GetActivityResult {
        val builder = GetActivityPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getActivityResultToKotlin(getActivityPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing an AWS SFN (Step Functions) State Machine Alias.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.sfn.SfnFunctions;
     * import com.pulumi.aws.sfn.inputs.GetAliasArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = SfnFunctions.getAlias(GetAliasArgs.builder()
     *             .name("my_sfn_alias")
     *             .statemachineArn(aws_sfn_state_machine.sfn_test().arn())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getAlias.
     * @return A collection of values returned by getAlias.
     */
    public suspend fun getAlias(argument: GetAliasPlainArgs): GetAliasResult =
        getAliasResultToKotlin(getAliasPlain(argument.toJava()).await())

    /**
     * @see [getAlias].
     * @param description Description of state machine alias.
     * @param name Name of the State Machine alias.
     * @param statemachineArn ARN of the State Machine.
     * @return A collection of values returned by getAlias.
     */
    public suspend fun getAlias(
        description: String? = null,
        name: String,
        statemachineArn: String,
    ): GetAliasResult {
        val argument = GetAliasPlainArgs(
            description = description,
            name = name,
            statemachineArn = statemachineArn,
        )
        return getAliasResultToKotlin(getAliasPlain(argument.toJava()).await())
    }

    /**
     * @see [getAlias].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;sfn&#46;kotlin&#46;inputs&#46;GetAliasPlainArgs].
     * @return A collection of values returned by getAlias.
     */
    public suspend fun getAlias(argument: suspend GetAliasPlainArgsBuilder.() -> Unit):
        GetAliasResult {
        val builder = GetAliasPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAliasResultToKotlin(getAliasPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get the ARN of a State Machine in AWS Step
     * Function (SFN). By using this data source, you can reference a
     * state machine without having to hard code the ARNs as input.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.sfn.SfnFunctions;
     * import com.pulumi.aws.sfn.inputs.GetStateMachineArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = SfnFunctions.getStateMachine(GetStateMachineArgs.builder()
     *             .name("an_example_sfn_name")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getStateMachine.
     * @return A collection of values returned by getStateMachine.
     */
    public suspend fun getStateMachine(argument: GetStateMachinePlainArgs): GetStateMachineResult =
        getStateMachineResultToKotlin(getStateMachinePlain(argument.toJava()).await())

    /**
     * @see [getStateMachine].
     * @param name Friendly name of the state machine to match.
     * @return A collection of values returned by getStateMachine.
     */
    public suspend fun getStateMachine(name: String): GetStateMachineResult {
        val argument = GetStateMachinePlainArgs(
            name = name,
        )
        return getStateMachineResultToKotlin(getStateMachinePlain(argument.toJava()).await())
    }

    /**
     * @see [getStateMachine].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;sfn&#46;kotlin&#46;inputs&#46;GetStateMachinePlainArgs].
     * @return A collection of values returned by getStateMachine.
     */
    public suspend fun getStateMachine(argument: suspend GetStateMachinePlainArgsBuilder.() -> Unit):
        GetStateMachineResult {
        val builder = GetStateMachinePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getStateMachineResultToKotlin(getStateMachinePlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing an AWS SFN (Step Functions) State Machine Versions.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.sfn.SfnFunctions;
     * import com.pulumi.aws.sfn.inputs.GetStateMachineVersionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = SfnFunctions.getStateMachineVersions(GetStateMachineVersionsArgs.builder()
     *             .statemachineArn(aws_sfn_state_machine.test().arn())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getStateMachineVersions.
     * @return A collection of values returned by getStateMachineVersions.
     */
    public suspend fun getStateMachineVersions(argument: GetStateMachineVersionsPlainArgs):
        GetStateMachineVersionsResult =
        getStateMachineVersionsResultToKotlin(getStateMachineVersionsPlain(argument.toJava()).await())

    /**
     * @see [getStateMachineVersions].
     * @param statemachineArn ARN of the State Machine.
     * @return A collection of values returned by getStateMachineVersions.
     */
    public suspend fun getStateMachineVersions(statemachineArn: String):
        GetStateMachineVersionsResult {
        val argument = GetStateMachineVersionsPlainArgs(
            statemachineArn = statemachineArn,
        )
        return getStateMachineVersionsResultToKotlin(getStateMachineVersionsPlain(argument.toJava()).await())
    }

    /**
     * @see [getStateMachineVersions].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;sfn&#46;kotlin&#46;inputs&#46;GetStateMachineVersionsPlainArgs].
     * @return A collection of values returned by getStateMachineVersions.
     */
    public suspend
    fun getStateMachineVersions(argument: suspend GetStateMachineVersionsPlainArgsBuilder.() -> Unit):
        GetStateMachineVersionsResult {
        val builder = GetStateMachineVersionsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getStateMachineVersionsResultToKotlin(getStateMachineVersionsPlain(builtArgument.toJava()).await())
    }
}
