@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sfn.kotlin

import com.pulumi.aws.sfn.kotlin.outputs.StateMachineLoggingConfiguration
import com.pulumi.aws.sfn.kotlin.outputs.StateMachineTracingConfiguration
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.sfn.kotlin.outputs.StateMachineLoggingConfiguration.Companion.toKotlin as stateMachineLoggingConfigurationToKotlin
import com.pulumi.aws.sfn.kotlin.outputs.StateMachineTracingConfiguration.Companion.toKotlin as stateMachineTracingConfigurationToKotlin

/**
 * Builder for [StateMachine].
 */
@PulumiTagMarker
public class StateMachineResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StateMachineArgs = StateMachineArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StateMachineArgsBuilder.() -> Unit) {
        val builder = StateMachineArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): StateMachine {
        val builtJavaResource = com.pulumi.aws.sfn.StateMachine(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return StateMachine(builtJavaResource)
    }
}

/**
 * Provides a Step Function State Machine resource
 * ## Example Usage
 * ### Basic (Standard Workflow)
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sfn.StateMachine;
 * import com.pulumi.aws.sfn.StateMachineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sfnStateMachine = new StateMachine("sfnStateMachine", StateMachineArgs.builder()
 *             .roleArn(aws_iam_role.iam_for_sfn().arn())
 *             .definition("""
 * {
 *   "Comment": "A Hello World example of the Amazon States Language using an AWS Lambda Function",
 *   "StartAt": "HelloWorld",
 *   "States": {
 *     "HelloWorld": {
 *       "Type": "Task",
 *       "Resource": "%s",
 *       "End": true
 *     }
 *   }
 * }
 * ", aws_lambda_function.lambda().arn()))
 *             .build());
 *     }
 * }
 * ```
 * ### Basic (Express Workflow)
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sfn.StateMachine;
 * import com.pulumi.aws.sfn.StateMachineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sfnStateMachine = new StateMachine("sfnStateMachine", StateMachineArgs.builder()
 *             .roleArn(aws_iam_role.iam_for_sfn().arn())
 *             .type("EXPRESS")
 *             .definition("""
 * {
 *   "Comment": "A Hello World example of the Amazon States Language using an AWS Lambda Function",
 *   "StartAt": "HelloWorld",
 *   "States": {
 *     "HelloWorld": {
 *       "Type": "Task",
 *       "Resource": "%s",
 *       "End": true
 *     }
 *   }
 * }
 * ", aws_lambda_function.lambda().arn()))
 *             .build());
 *     }
 * }
 * ```
 * ### Publish (Publish SFN version)
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sfn.StateMachine;
 * import com.pulumi.aws.sfn.StateMachineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sfnStateMachine = new StateMachine("sfnStateMachine", StateMachineArgs.builder()
 *             .roleArn(aws_iam_role.iam_for_sfn().arn())
 *             .publish(true)
 *             .type("EXPRESS")
 *             .definition("""
 * {
 *   "Comment": "A Hello World example of the Amazon States Language using an AWS Lambda Function",
 *   "StartAt": "HelloWorld",
 *   "States": {
 *     "HelloWorld": {
 *       "Type": "Task",
 *       "Resource": "%s",
 *       "End": true
 *     }
 *   }
 * }
 * ", aws_lambda_function.lambda().arn()))
 *             .build());
 *     }
 * }
 * ```
 * ### Logging
 * > *NOTE:* See the [AWS Step Functions Developer Guide](https://docs.aws.amazon.com/step-functions/latest/dg/welcome.html) for more information about enabling Step Function logging.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sfn.StateMachine;
 * import com.pulumi.aws.sfn.StateMachineArgs;
 * import com.pulumi.aws.sfn.inputs.StateMachineLoggingConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sfnStateMachine = new StateMachine("sfnStateMachine", StateMachineArgs.builder()
 *             .roleArn(aws_iam_role.iam_for_sfn().arn())
 *             .definition("""
 * {
 *   "Comment": "A Hello World example of the Amazon States Language using an AWS Lambda Function",
 *   "StartAt": "HelloWorld",
 *   "States": {
 *     "HelloWorld": {
 *       "Type": "Task",
 *       "Resource": "%s",
 *       "End": true
 *     }
 *   }
 * }
 * ", aws_lambda_function.lambda().arn()))
 *             .loggingConfiguration(StateMachineLoggingConfigurationArgs.builder()
 *                 .logDestination(String.format("%s:*", aws_cloudwatch_log_group.log_group_for_sfn().arn()))
 *                 .includeExecutionData(true)
 *                 .level("ERROR")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import State Machines using the `arn`. For example:
 * ```sh
 *  $ pulumi import aws:sfn/stateMachine:StateMachine foo arn:aws:states:eu-west-1:123456789098:stateMachine:bar
 * ```
 *
 */
public class StateMachine internal constructor(
    override val javaResource: com.pulumi.aws.sfn.StateMachine,
) : KotlinCustomResource(javaResource, StateMachineMapper) {
    /**
     * The ARN of the state machine.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The date the state machine was created.
     */
    public val creationDate: Output<String>
        get() = javaResource.creationDate().applyValue({ args0 -> args0 })

    /**
     * The [Amazon States Language](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html) definition of the state machine.
     */
    public val definition: Output<String>
        get() = javaResource.definition().applyValue({ args0 -> args0 })

    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * Defines what execution history events are logged and where they are logged. The `logging_configuration` parameter is only valid when `type` is set to `EXPRESS`. Defaults to `OFF`. For more information see [Logging Express Workflows](https://docs&#46;aws&#46;amazon&#46;com/step-functions/latest/dg/cw-logs&#46;html) and [Log Levels](https://docs.aws.amazon.com/step-functions/latest/dg/cloudwatch-log-level.html) in the AWS Step Functions User Guide.
     */
    public val loggingConfiguration: Output<StateMachineLoggingConfiguration>
        get() = javaResource.loggingConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                stateMachineLoggingConfigurationToKotlin(args0)
            })
        })

    /**
     * The name of the state machine. The name should only contain `0`-`9`, `A`-`Z`, `a`-`z`, `-` and `_`. If omitted, the provider will assign a random, unique name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    public val namePrefix: Output<String>
        get() = javaResource.namePrefix().applyValue({ args0 -> args0 })

    /**
     * Set to true to publish a version of the state machine during creation. Default: false.
     */
    public val publish: Output<Boolean>?
        get() = javaResource.publish().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val revisionId: Output<String>
        get() = javaResource.revisionId().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the IAM role to use for this state machine.
     */
    public val roleArn: Output<String>
        get() = javaResource.roleArn().applyValue({ args0 -> args0 })

    public val stateMachineVersionArn: Output<String>
        get() = javaResource.stateMachineVersionArn().applyValue({ args0 -> args0 })

    /**
     * The current status of the state machine. Either `ACTIVE` or `DELETING`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Selects whether AWS X-Ray tracing is enabled.
     */
    public val tracingConfiguration: Output<StateMachineTracingConfiguration>
        get() = javaResource.tracingConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                stateMachineTracingConfigurationToKotlin(args0)
            })
        })

    /**
     * Determines whether a Standard or Express state machine is created. The default is `STANDARD`. You cannot update the type of a state machine once it has been created. Valid values: `STANDARD`, `EXPRESS`.
     */
    public val type: Output<String>?
        get() = javaResource.type().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val versionDescription: Output<String>
        get() = javaResource.versionDescription().applyValue({ args0 -> args0 })
}

public object StateMachineMapper : ResourceMapper<StateMachine> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sfn.StateMachine::class == javaResource::class

    override fun map(javaResource: Resource): StateMachine = StateMachine(
        javaResource as
            com.pulumi.aws.sfn.StateMachine,
    )
}

/**
 * @see [StateMachine].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [StateMachine].
 */
public suspend fun stateMachine(
    name: String,
    block: suspend StateMachineResourceBuilder.() -> Unit,
): StateMachine {
    val builder = StateMachineResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [StateMachine].
 * @param name The _unique_ name of the resulting resource.
 */
public fun stateMachine(name: String): StateMachine {
    val builder = StateMachineResourceBuilder()
    builder.name(name)
    return builder.build()
}
