@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sfn.kotlin

import com.pulumi.aws.sfn.StateMachineArgs.builder
import com.pulumi.aws.sfn.kotlin.inputs.StateMachineLoggingConfigurationArgs
import com.pulumi.aws.sfn.kotlin.inputs.StateMachineLoggingConfigurationArgsBuilder
import com.pulumi.aws.sfn.kotlin.inputs.StateMachineTracingConfigurationArgs
import com.pulumi.aws.sfn.kotlin.inputs.StateMachineTracingConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Step Function State Machine resource
 * ## Example Usage
 * ### Basic (Standard Workflow)
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sfn.StateMachine;
 * import com.pulumi.aws.sfn.StateMachineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sfnStateMachine = new StateMachine("sfnStateMachine", StateMachineArgs.builder()
 *             .roleArn(aws_iam_role.iam_for_sfn().arn())
 *             .definition("""
 * {
 *   "Comment": "A Hello World example of the Amazon States Language using an AWS Lambda Function",
 *   "StartAt": "HelloWorld",
 *   "States": {
 *     "HelloWorld": {
 *       "Type": "Task",
 *       "Resource": "%s",
 *       "End": true
 *     }
 *   }
 * }
 * ", aws_lambda_function.lambda().arn()))
 *             .build());
 *     }
 * }
 * ```
 * ### Basic (Express Workflow)
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sfn.StateMachine;
 * import com.pulumi.aws.sfn.StateMachineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sfnStateMachine = new StateMachine("sfnStateMachine", StateMachineArgs.builder()
 *             .roleArn(aws_iam_role.iam_for_sfn().arn())
 *             .type("EXPRESS")
 *             .definition("""
 * {
 *   "Comment": "A Hello World example of the Amazon States Language using an AWS Lambda Function",
 *   "StartAt": "HelloWorld",
 *   "States": {
 *     "HelloWorld": {
 *       "Type": "Task",
 *       "Resource": "%s",
 *       "End": true
 *     }
 *   }
 * }
 * ", aws_lambda_function.lambda().arn()))
 *             .build());
 *     }
 * }
 * ```
 * ### Publish (Publish SFN version)
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sfn.StateMachine;
 * import com.pulumi.aws.sfn.StateMachineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sfnStateMachine = new StateMachine("sfnStateMachine", StateMachineArgs.builder()
 *             .roleArn(aws_iam_role.iam_for_sfn().arn())
 *             .publish(true)
 *             .type("EXPRESS")
 *             .definition("""
 * {
 *   "Comment": "A Hello World example of the Amazon States Language using an AWS Lambda Function",
 *   "StartAt": "HelloWorld",
 *   "States": {
 *     "HelloWorld": {
 *       "Type": "Task",
 *       "Resource": "%s",
 *       "End": true
 *     }
 *   }
 * }
 * ", aws_lambda_function.lambda().arn()))
 *             .build());
 *     }
 * }
 * ```
 * ### Logging
 * > *NOTE:* See the [AWS Step Functions Developer Guide](https://docs.aws.amazon.com/step-functions/latest/dg/welcome.html) for more information about enabling Step Function logging.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sfn.StateMachine;
 * import com.pulumi.aws.sfn.StateMachineArgs;
 * import com.pulumi.aws.sfn.inputs.StateMachineLoggingConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sfnStateMachine = new StateMachine("sfnStateMachine", StateMachineArgs.builder()
 *             .roleArn(aws_iam_role.iam_for_sfn().arn())
 *             .definition("""
 * {
 *   "Comment": "A Hello World example of the Amazon States Language using an AWS Lambda Function",
 *   "StartAt": "HelloWorld",
 *   "States": {
 *     "HelloWorld": {
 *       "Type": "Task",
 *       "Resource": "%s",
 *       "End": true
 *     }
 *   }
 * }
 * ", aws_lambda_function.lambda().arn()))
 *             .loggingConfiguration(StateMachineLoggingConfigurationArgs.builder()
 *                 .logDestination(String.format("%s:*", aws_cloudwatch_log_group.log_group_for_sfn().arn()))
 *                 .includeExecutionData(true)
 *                 .level("ERROR")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import State Machines using the `arn`. For example:
 * ```sh
 *  $ pulumi import aws:sfn/stateMachine:StateMachine foo arn:aws:states:eu-west-1:123456789098:stateMachine:bar
 * ```
 * @property definition The [Amazon States Language](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html) definition of the state machine.
 * @property loggingConfiguration Defines what execution history events are logged and where they are logged. The `logging_configuration` parameter is only valid when `type` is set to `EXPRESS`. Defaults to `OFF`. For more information see [Logging Express Workflows](https://docs&#46;aws&#46;amazon&#46;com/step-functions/latest/dg/cw-logs&#46;html) and [Log Levels](https://docs.aws.amazon.com/step-functions/latest/dg/cloudwatch-log-level.html) in the AWS Step Functions User Guide.
 * @property name The name of the state machine. The name should only contain `0`-`9`, `A`-`Z`, `a`-`z`, `-` and `_`. If omitted, the provider will assign a random, unique name.
 * @property namePrefix Creates a unique name beginning with the specified prefix. Conflicts with `name`.
 * @property publish Set to true to publish a version of the state machine during creation. Default: false.
 * @property roleArn The Amazon Resource Name (ARN) of the IAM role to use for this state machine.
 * @property tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property tracingConfiguration Selects whether AWS X-Ray tracing is enabled.
 * @property type Determines whether a Standard or Express state machine is created. The default is `STANDARD`. You cannot update the type of a state machine once it has been created. Valid values: `STANDARD`, `EXPRESS`.
 */
public data class StateMachineArgs(
    public val definition: Output<String>? = null,
    public val loggingConfiguration: Output<StateMachineLoggingConfigurationArgs>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val publish: Output<Boolean>? = null,
    public val roleArn: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val tracingConfiguration: Output<StateMachineTracingConfigurationArgs>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sfn.StateMachineArgs> {
    override fun toJava(): com.pulumi.aws.sfn.StateMachineArgs =
        com.pulumi.aws.sfn.StateMachineArgs.builder()
            .definition(definition?.applyValue({ args0 -> args0 }))
            .loggingConfiguration(
                loggingConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .publish(publish?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .tracingConfiguration(
                tracingConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StateMachineArgs].
 */
@PulumiTagMarker
public class StateMachineArgsBuilder internal constructor() {
    private var definition: Output<String>? = null

    private var loggingConfiguration: Output<StateMachineLoggingConfigurationArgs>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var publish: Output<Boolean>? = null

    private var roleArn: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var tracingConfiguration: Output<StateMachineTracingConfigurationArgs>? = null

    private var type: Output<String>? = null

    /**
     * @param value The [Amazon States Language](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html) definition of the state machine.
     */
    @JvmName("oflcnaeihomtnwbp")
    public suspend fun definition(`value`: Output<String>) {
        this.definition = value
    }

    /**
     * @param value Defines what execution history events are logged and where they are logged. The `logging_configuration` parameter is only valid when `type` is set to `EXPRESS`. Defaults to `OFF`. For more information see [Logging Express Workflows](https://docs&#46;aws&#46;amazon&#46;com/step-functions/latest/dg/cw-logs&#46;html) and [Log Levels](https://docs.aws.amazon.com/step-functions/latest/dg/cloudwatch-log-level.html) in the AWS Step Functions User Guide.
     */
    @JvmName("trbmdvbdftahqgcp")
    public suspend fun loggingConfiguration(`value`: Output<StateMachineLoggingConfigurationArgs>) {
        this.loggingConfiguration = value
    }

    /**
     * @param value The name of the state machine. The name should only contain `0`-`9`, `A`-`Z`, `a`-`z`, `-` and `_`. If omitted, the provider will assign a random, unique name.
     */
    @JvmName("lqayevueraxnnqwh")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("mwjptwhkcisrcqtp")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value Set to true to publish a version of the state machine during creation. Default: false.
     */
    @JvmName("hwuigaanfjyjafps")
    public suspend fun publish(`value`: Output<Boolean>) {
        this.publish = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the IAM role to use for this state machine.
     */
    @JvmName("hemiopqsxekfroqi")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("sqlifqdfjxldwyuj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Selects whether AWS X-Ray tracing is enabled.
     */
    @JvmName("hiyhbwlcbeprycpr")
    public suspend fun tracingConfiguration(`value`: Output<StateMachineTracingConfigurationArgs>) {
        this.tracingConfiguration = value
    }

    /**
     * @param value Determines whether a Standard or Express state machine is created. The default is `STANDARD`. You cannot update the type of a state machine once it has been created. Valid values: `STANDARD`, `EXPRESS`.
     */
    @JvmName("wtvehctvlhmjsaiw")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The [Amazon States Language](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html) definition of the state machine.
     */
    @JvmName("dwpqvgmrdhjvapvj")
    public suspend fun definition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.definition = mapped
    }

    /**
     * @param value Defines what execution history events are logged and where they are logged. The `logging_configuration` parameter is only valid when `type` is set to `EXPRESS`. Defaults to `OFF`. For more information see [Logging Express Workflows](https://docs&#46;aws&#46;amazon&#46;com/step-functions/latest/dg/cw-logs&#46;html) and [Log Levels](https://docs.aws.amazon.com/step-functions/latest/dg/cloudwatch-log-level.html) in the AWS Step Functions User Guide.
     */
    @JvmName("nyutnbbhhamebwch")
    public suspend fun loggingConfiguration(`value`: StateMachineLoggingConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loggingConfiguration = mapped
    }

    /**
     * @param argument Defines what execution history events are logged and where they are logged. The `logging_configuration` parameter is only valid when `type` is set to `EXPRESS`. Defaults to `OFF`. For more information see [Logging Express Workflows](https://docs&#46;aws&#46;amazon&#46;com/step-functions/latest/dg/cw-logs&#46;html) and [Log Levels](https://docs.aws.amazon.com/step-functions/latest/dg/cloudwatch-log-level.html) in the AWS Step Functions User Guide.
     */
    @JvmName("yoiuomqnxgmgtpns")
    public suspend
    fun loggingConfiguration(argument: suspend StateMachineLoggingConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = StateMachineLoggingConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.loggingConfiguration = mapped
    }

    /**
     * @param value The name of the state machine. The name should only contain `0`-`9`, `A`-`Z`, `a`-`z`, `-` and `_`. If omitted, the provider will assign a random, unique name.
     */
    @JvmName("uopdhfrcvoyggjys")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("gusxgnhicyrpnrok")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value Set to true to publish a version of the state machine during creation. Default: false.
     */
    @JvmName("tqeaojfsqknewwhs")
    public suspend fun publish(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publish = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the IAM role to use for this state machine.
     */
    @JvmName("rerjwogjccuohpgr")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wxjcaycvdxmefgoo")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bshwdfmtdesfumud")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Selects whether AWS X-Ray tracing is enabled.
     */
    @JvmName("blekomdqfkwepenf")
    public suspend fun tracingConfiguration(`value`: StateMachineTracingConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tracingConfiguration = mapped
    }

    /**
     * @param argument Selects whether AWS X-Ray tracing is enabled.
     */
    @JvmName("cvnmnbecntaenspx")
    public suspend
    fun tracingConfiguration(argument: suspend StateMachineTracingConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = StateMachineTracingConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.tracingConfiguration = mapped
    }

    /**
     * @param value Determines whether a Standard or Express state machine is created. The default is `STANDARD`. You cannot update the type of a state machine once it has been created. Valid values: `STANDARD`, `EXPRESS`.
     */
    @JvmName("hdycamdoxwimjfli")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): StateMachineArgs = StateMachineArgs(
        definition = definition,
        loggingConfiguration = loggingConfiguration,
        name = name,
        namePrefix = namePrefix,
        publish = publish,
        roleArn = roleArn,
        tags = tags,
        tracingConfiguration = tracingConfiguration,
        type = type,
    )
}
