@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sfn.kotlin.inputs

import com.pulumi.aws.sfn.inputs.AliasRoutingConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property stateMachineVersionArn The Amazon Resource Name (ARN) of the state machine version.
 * @property weight Percentage of traffic routed to the state machine version.
 */
public data class AliasRoutingConfigurationArgs(
    public val stateMachineVersionArn: Output<String>,
    public val weight: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.sfn.inputs.AliasRoutingConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.sfn.inputs.AliasRoutingConfigurationArgs =
        com.pulumi.aws.sfn.inputs.AliasRoutingConfigurationArgs.builder()
            .stateMachineVersionArn(stateMachineVersionArn.applyValue({ args0 -> args0 }))
            .weight(weight.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AliasRoutingConfigurationArgs].
 */
@PulumiTagMarker
public class AliasRoutingConfigurationArgsBuilder internal constructor() {
    private var stateMachineVersionArn: Output<String>? = null

    private var weight: Output<Int>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the state machine version.
     */
    @JvmName("ybhfeagjgnrbrrdd")
    public suspend fun stateMachineVersionArn(`value`: Output<String>) {
        this.stateMachineVersionArn = value
    }

    /**
     * @param value Percentage of traffic routed to the state machine version.
     */
    @JvmName("awyqvwnjghotyccf")
    public suspend fun weight(`value`: Output<Int>) {
        this.weight = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the state machine version.
     */
    @JvmName("nalufrqsagbywcfo")
    public suspend fun stateMachineVersionArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stateMachineVersionArn = mapped
    }

    /**
     * @param value Percentage of traffic routed to the state machine version.
     */
    @JvmName("qxypuytivjdsrtoq")
    public suspend fun weight(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.weight = mapped
    }

    internal fun build(): AliasRoutingConfigurationArgs = AliasRoutingConfigurationArgs(
        stateMachineVersionArn = stateMachineVersionArn ?: throw
            PulumiNullFieldException("stateMachineVersionArn"),
        weight = weight ?: throw PulumiNullFieldException("weight"),
    )
}
