@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sfn.kotlin.inputs

import com.pulumi.aws.sfn.inputs.GetAliasPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAlias.
 * @property description Description of state machine alias.
 * @property name Name of the State Machine alias.
 * @property statemachineArn ARN of the State Machine.
 */
public data class GetAliasPlainArgs(
    public val description: String? = null,
    public val name: String,
    public val statemachineArn: String,
) : ConvertibleToJava<com.pulumi.aws.sfn.inputs.GetAliasPlainArgs> {
    override fun toJava(): com.pulumi.aws.sfn.inputs.GetAliasPlainArgs =
        com.pulumi.aws.sfn.inputs.GetAliasPlainArgs.builder()
            .description(description?.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .statemachineArn(statemachineArn.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAliasPlainArgs].
 */
@PulumiTagMarker
public class GetAliasPlainArgsBuilder internal constructor() {
    private var description: String? = null

    private var name: String? = null

    private var statemachineArn: String? = null

    /**
     * @param value Description of state machine alias.
     */
    @JvmName("iafxsyirpmenpyyn")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.description = mapped
    }

    /**
     * @param value Name of the State Machine alias.
     */
    @JvmName("rtdtfuuyxtuiynhf")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value ARN of the State Machine.
     */
    @JvmName("euswnvgyvawafgaf")
    public suspend fun statemachineArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.statemachineArn = mapped
    }

    internal fun build(): GetAliasPlainArgs = GetAliasPlainArgs(
        description = description,
        name = name ?: throw PulumiNullFieldException("name"),
        statemachineArn = statemachineArn ?: throw PulumiNullFieldException("statemachineArn"),
    )
}
