@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sfn.kotlin.inputs

import com.pulumi.aws.sfn.inputs.GetStateMachinePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getStateMachine.
 * @property name Friendly name of the state machine to match.
 */
public data class GetStateMachinePlainArgs(
    public val name: String,
) : ConvertibleToJava<com.pulumi.aws.sfn.inputs.GetStateMachinePlainArgs> {
    override fun toJava(): com.pulumi.aws.sfn.inputs.GetStateMachinePlainArgs =
        com.pulumi.aws.sfn.inputs.GetStateMachinePlainArgs.builder()
            .name(name.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetStateMachinePlainArgs].
 */
@PulumiTagMarker
public class GetStateMachinePlainArgsBuilder internal constructor() {
    private var name: String? = null

    /**
     * @param value Friendly name of the state machine to match.
     */
    @JvmName("kfbcdjqumalotbci")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetStateMachinePlainArgs = GetStateMachinePlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
