@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sfn.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property stateMachineVersionArn The Amazon Resource Name (ARN) of the state machine version.
 * @property weight Percentage of traffic routed to the state machine version.
 */
public data class AliasRoutingConfiguration(
    public val stateMachineVersionArn: String,
    public val weight: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sfn.outputs.AliasRoutingConfiguration):
            AliasRoutingConfiguration = AliasRoutingConfiguration(
            stateMachineVersionArn = javaType.stateMachineVersionArn(),
            weight = javaType.weight(),
        )
    }
}
