@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sfn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getActivity.
 * @property arn
 * @property creationDate Date the activity was created.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name
 */
public data class GetActivityResult(
    public val arn: String,
    public val creationDate: String,
    public val id: String,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sfn.outputs.GetActivityResult): GetActivityResult =
            GetActivityResult(
                arn = javaType.arn(),
                creationDate = javaType.creationDate(),
                id = javaType.id(),
                name = javaType.name(),
            )
    }
}
