@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sfn.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getAlias.
 * @property arn ARN identifying the State Machine alias.
 * @property creationDate Date the state machine Alias was created.
 * @property description Description of state machine alias.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name
 * @property routingConfigurations Routing Configuration of state machine alias
 * @property statemachineArn
 */
public data class GetAliasResult(
    public val arn: String,
    public val creationDate: String,
    public val description: String? = null,
    public val id: String,
    public val name: String,
    public val routingConfigurations: List<GetAliasRoutingConfiguration>,
    public val statemachineArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sfn.outputs.GetAliasResult): GetAliasResult =
            GetAliasResult(
                arn = javaType.arn(),
                creationDate = javaType.creationDate(),
                description = javaType.description().map({ args0 -> args0 }).orElse(null),
                id = javaType.id(),
                name = javaType.name(),
                routingConfigurations = javaType.routingConfigurations().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.sfn.kotlin.outputs.GetAliasRoutingConfiguration.Companion.toKotlin(args0)
                    })
                }),
                statemachineArn = javaType.statemachineArn(),
            )
    }
}
