@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sfn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getStateMachine.
 * @property arn Set to the arn of the state function.
 * @property creationDate Date the state machine was created.
 * @property definition Set to the state machine definition.
 * @property description
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name
 * @property revisionId The revision identifier for the state machine.
 * @property roleArn Set to the role_arn used by the state function.
 * @property status Set to the current status of the state machine.
 */
public data class GetStateMachineResult(
    public val arn: String,
    public val creationDate: String,
    public val definition: String,
    public val description: String,
    public val id: String,
    public val name: String,
    public val revisionId: String,
    public val roleArn: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sfn.outputs.GetStateMachineResult):
            GetStateMachineResult = GetStateMachineResult(
            arn = javaType.arn(),
            creationDate = javaType.creationDate(),
            definition = javaType.definition(),
            description = javaType.description(),
            id = javaType.id(),
            name = javaType.name(),
            revisionId = javaType.revisionId(),
            roleArn = javaType.roleArn(),
            status = javaType.status(),
        )
    }
}
