@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sfn.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property enabled When set to `true`, AWS X-Ray tracing is enabled. Make sure the State Machine has the correct IAM policies for logging. See the [AWS Step Functions Developer Guide](https://docs.aws.amazon.com/step-functions/latest/dg/xray-iam.html) for details.
 */
public data class StateMachineTracingConfiguration(
    public val enabled: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sfn.outputs.StateMachineTracingConfiguration):
            StateMachineTracingConfiguration = StateMachineTracingConfiguration(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
        )
    }
}
