@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.shield.kotlin

import com.pulumi.aws.shield.kotlin.outputs.ApplicationLayerAutomaticResponseTimeouts
import com.pulumi.aws.shield.kotlin.outputs.ApplicationLayerAutomaticResponseTimeouts.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ApplicationLayerAutomaticResponse].
 */
@PulumiTagMarker
public class ApplicationLayerAutomaticResponseResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApplicationLayerAutomaticResponseArgs = ApplicationLayerAutomaticResponseArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApplicationLayerAutomaticResponseArgsBuilder.() -> Unit) {
        val builder = ApplicationLayerAutomaticResponseArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ApplicationLayerAutomaticResponse {
        val builtJavaResource =
            com.pulumi.aws.shield.ApplicationLayerAutomaticResponse(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ApplicationLayerAutomaticResponse(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Shield Application Layer Automatic Response for automatic DDoS mitigation.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.inputs.GetPartitionArgs;
 * import com.pulumi.aws.shield.ApplicationLayerAutomaticResponse;
 * import com.pulumi.aws.shield.ApplicationLayerAutomaticResponseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var currentRegion = AwsFunctions.getRegion();
 *         final var currentCallerIdentity = AwsFunctions.getCallerIdentity();
 *         final var currentPartition = AwsFunctions.getPartition();
 *         var example = new ApplicationLayerAutomaticResponse("example", ApplicationLayerAutomaticResponseArgs.builder()
 *             .action("COUNT")
 *             .resourceArn(String.format("arn:%s:cloudfront:%s:distribution/%s", currentPartition.applyValue(getPartitionResult -> getPartitionResult.partition()),currentCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()),var_.distribution_id()))
 *             .build());
 *     }
 * }
 * ```
 */
public class ApplicationLayerAutomaticResponse internal constructor(
    override val javaResource: com.pulumi.aws.shield.ApplicationLayerAutomaticResponse,
) : KotlinCustomResource(javaResource, ApplicationLayerAutomaticResponseMapper) {
    /**
     * One of `COUNT` or `BLOCK`
     */
    public val action: Output<String>
        get() = javaResource.action().applyValue({ args0 -> args0 })

    /**
     * ARN of the resource to protect (Cloudfront Distributions and ALBs only at this time).
     */
    public val resourceArn: Output<String>
        get() = javaResource.resourceArn().applyValue({ args0 -> args0 })

    public val timeouts: Output<ApplicationLayerAutomaticResponseTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })
}

public object ApplicationLayerAutomaticResponseMapper :
    ResourceMapper<ApplicationLayerAutomaticResponse> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.shield.ApplicationLayerAutomaticResponse::class == javaResource::class

    override fun map(javaResource: Resource): ApplicationLayerAutomaticResponse =
        ApplicationLayerAutomaticResponse(
            javaResource as
                com.pulumi.aws.shield.ApplicationLayerAutomaticResponse,
        )
}

/**
 * @see [ApplicationLayerAutomaticResponse].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ApplicationLayerAutomaticResponse].
 */
public suspend fun applicationLayerAutomaticResponse(
    name: String,
    block: suspend ApplicationLayerAutomaticResponseResourceBuilder.() -> Unit,
):
    ApplicationLayerAutomaticResponse {
    val builder = ApplicationLayerAutomaticResponseResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ApplicationLayerAutomaticResponse].
 * @param name The _unique_ name of the resulting resource.
 */
public fun applicationLayerAutomaticResponse(name: String): ApplicationLayerAutomaticResponse {
    val builder = ApplicationLayerAutomaticResponseResourceBuilder()
    builder.name(name)
    return builder.build()
}
