@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.shield.kotlin

import com.pulumi.aws.shield.kotlin.outputs.DrtAccessLogBucketAssociationTimeouts
import com.pulumi.aws.shield.kotlin.outputs.DrtAccessLogBucketAssociationTimeouts.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DrtAccessLogBucketAssociation].
 */
@PulumiTagMarker
public class DrtAccessLogBucketAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DrtAccessLogBucketAssociationArgs = DrtAccessLogBucketAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DrtAccessLogBucketAssociationArgsBuilder.() -> Unit) {
        val builder = DrtAccessLogBucketAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DrtAccessLogBucketAssociation {
        val builtJavaResource =
            com.pulumi.aws.shield.DrtAccessLogBucketAssociation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DrtAccessLogBucketAssociation(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Shield DRT Access Log Bucket Association. Up to 10 log buckets can be associated for DRT Access sharing with the Shield Response Team (SRT).
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.shield.DrtAccessRoleArnAssociation;
 * import com.pulumi.aws.shield.DrtAccessRoleArnAssociationArgs;
 * import com.pulumi.aws.shield.DrtAccessLogBucketAssociation;
 * import com.pulumi.aws.shield.DrtAccessLogBucketAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testDrtAccessRoleArnAssociation = new DrtAccessRoleArnAssociation("testDrtAccessRoleArnAssociation", DrtAccessRoleArnAssociationArgs.builder()
 *             .roleArn(String.format("arn:aws:iam:%s:%s:%s", data.aws_region().current().name(),data.aws_caller_identity().current().account_id(),var_.shield_drt_access_role_name()))
 *             .build());
 *         var testDrtAccessLogBucketAssociation = new DrtAccessLogBucketAssociation("testDrtAccessLogBucketAssociation", DrtAccessLogBucketAssociationArgs.builder()
 *             .logBucket(var_.shield_drt_access_log_bucket())
 *             .roleArnAssociationId(testDrtAccessRoleArnAssociation.id())
 *             .build());
 *     }
 * }
 * ```
 */
public class DrtAccessLogBucketAssociation internal constructor(
    override val javaResource: com.pulumi.aws.shield.DrtAccessLogBucketAssociation,
) : KotlinCustomResource(javaResource, DrtAccessLogBucketAssociationMapper) {
    /**
     * The Amazon S3 bucket that contains the logs that you want to share.
     */
    public val logBucket: Output<String>
        get() = javaResource.logBucket().applyValue({ args0 -> args0 })

    /**
     * The ID of the Role Arn association used for allowing Shield DRT Access.
     */
    public val roleArnAssociationId: Output<String>
        get() = javaResource.roleArnAssociationId().applyValue({ args0 -> args0 })

    public val timeouts: Output<DrtAccessLogBucketAssociationTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })
}

public object DrtAccessLogBucketAssociationMapper : ResourceMapper<DrtAccessLogBucketAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.shield.DrtAccessLogBucketAssociation::class == javaResource::class

    override fun map(javaResource: Resource): DrtAccessLogBucketAssociation =
        DrtAccessLogBucketAssociation(
            javaResource as
                com.pulumi.aws.shield.DrtAccessLogBucketAssociation,
        )
}

/**
 * @see [DrtAccessLogBucketAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DrtAccessLogBucketAssociation].
 */
public suspend fun drtAccessLogBucketAssociation(
    name: String,
    block: suspend DrtAccessLogBucketAssociationResourceBuilder.() -> Unit,
):
    DrtAccessLogBucketAssociation {
    val builder = DrtAccessLogBucketAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DrtAccessLogBucketAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun drtAccessLogBucketAssociation(name: String): DrtAccessLogBucketAssociation {
    val builder = DrtAccessLogBucketAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
