@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.shield.kotlin

import com.pulumi.aws.shield.DrtAccessLogBucketAssociationArgs.builder
import com.pulumi.aws.shield.kotlin.inputs.DrtAccessLogBucketAssociationTimeoutsArgs
import com.pulumi.aws.shield.kotlin.inputs.DrtAccessLogBucketAssociationTimeoutsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Shield DRT Access Log Bucket Association. Up to 10 log buckets can be associated for DRT Access sharing with the Shield Response Team (SRT).
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.shield.DrtAccessRoleArnAssociation;
 * import com.pulumi.aws.shield.DrtAccessRoleArnAssociationArgs;
 * import com.pulumi.aws.shield.DrtAccessLogBucketAssociation;
 * import com.pulumi.aws.shield.DrtAccessLogBucketAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testDrtAccessRoleArnAssociation = new DrtAccessRoleArnAssociation("testDrtAccessRoleArnAssociation", DrtAccessRoleArnAssociationArgs.builder()
 *             .roleArn(String.format("arn:aws:iam:%s:%s:%s", data.aws_region().current().name(),data.aws_caller_identity().current().account_id(),var_.shield_drt_access_role_name()))
 *             .build());
 *         var testDrtAccessLogBucketAssociation = new DrtAccessLogBucketAssociation("testDrtAccessLogBucketAssociation", DrtAccessLogBucketAssociationArgs.builder()
 *             .logBucket(var_.shield_drt_access_log_bucket())
 *             .roleArnAssociationId(testDrtAccessRoleArnAssociation.id())
 *             .build());
 *     }
 * }
 * ```
 * @property logBucket The Amazon S3 bucket that contains the logs that you want to share.
 * @property roleArnAssociationId The ID of the Role Arn association used for allowing Shield DRT Access.
 * @property timeouts
 */
public data class DrtAccessLogBucketAssociationArgs(
    public val logBucket: Output<String>? = null,
    public val roleArnAssociationId: Output<String>? = null,
    public val timeouts: Output<DrtAccessLogBucketAssociationTimeoutsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.shield.DrtAccessLogBucketAssociationArgs> {
    override fun toJava(): com.pulumi.aws.shield.DrtAccessLogBucketAssociationArgs =
        com.pulumi.aws.shield.DrtAccessLogBucketAssociationArgs.builder()
            .logBucket(logBucket?.applyValue({ args0 -> args0 }))
            .roleArnAssociationId(roleArnAssociationId?.applyValue({ args0 -> args0 }))
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DrtAccessLogBucketAssociationArgs].
 */
@PulumiTagMarker
public class DrtAccessLogBucketAssociationArgsBuilder internal constructor() {
    private var logBucket: Output<String>? = null

    private var roleArnAssociationId: Output<String>? = null

    private var timeouts: Output<DrtAccessLogBucketAssociationTimeoutsArgs>? = null

    /**
     * @param value The Amazon S3 bucket that contains the logs that you want to share.
     */
    @JvmName("xsbeuqlnljwhmkxo")
    public suspend fun logBucket(`value`: Output<String>) {
        this.logBucket = value
    }

    /**
     * @param value The ID of the Role Arn association used for allowing Shield DRT Access.
     */
    @JvmName("sodifhhdhhcroeml")
    public suspend fun roleArnAssociationId(`value`: Output<String>) {
        this.roleArnAssociationId = value
    }

    /**
     * @param value
     */
    @JvmName("jcgsfinpalbcaqcn")
    public suspend fun timeouts(`value`: Output<DrtAccessLogBucketAssociationTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value The Amazon S3 bucket that contains the logs that you want to share.
     */
    @JvmName("vsaoefhjshnwskni")
    public suspend fun logBucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logBucket = mapped
    }

    /**
     * @param value The ID of the Role Arn association used for allowing Shield DRT Access.
     */
    @JvmName("sqqtlkiagcnorlfx")
    public suspend fun roleArnAssociationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArnAssociationId = mapped
    }

    /**
     * @param value
     */
    @JvmName("fxdhqxywlybtaqkt")
    public suspend fun timeouts(`value`: DrtAccessLogBucketAssociationTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("oympijpxfiacdpmu")
    public suspend
    fun timeouts(argument: suspend DrtAccessLogBucketAssociationTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = DrtAccessLogBucketAssociationTimeoutsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    internal fun build(): DrtAccessLogBucketAssociationArgs = DrtAccessLogBucketAssociationArgs(
        logBucket = logBucket,
        roleArnAssociationId = roleArnAssociationId,
        timeouts = timeouts,
    )
}
