@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.shield.kotlin

import com.pulumi.aws.shield.kotlin.outputs.DrtAccessRoleArnAssociationTimeouts
import com.pulumi.aws.shield.kotlin.outputs.DrtAccessRoleArnAssociationTimeouts.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DrtAccessRoleArnAssociation].
 */
@PulumiTagMarker
public class DrtAccessRoleArnAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DrtAccessRoleArnAssociationArgs = DrtAccessRoleArnAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DrtAccessRoleArnAssociationArgsBuilder.() -> Unit) {
        val builder = DrtAccessRoleArnAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DrtAccessRoleArnAssociation {
        val builtJavaResource =
            com.pulumi.aws.shield.DrtAccessRoleArnAssociation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DrtAccessRoleArnAssociation(builtJavaResource)
    }
}

/**
 * Authorizes the Shield Response Team (SRT) using the specified role, to access your AWS account to assist with DDoS attack mitigation during potential attacks. For more information see [Configure AWS SRT Support](https://docs.aws.amazon.com/waf/latest/developerguide/authorize-srt.html)
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.shield.DrtAccessRoleArnAssociation;
 * import com.pulumi.aws.shield.DrtAccessRoleArnAssociationArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testRole = new Role("testRole", RoleArgs.builder()
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Sid", ""),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("Service", "drt.shield.amazonaws.com")
 *                         )),
 *                         jsonProperty("Action", "sts:AssumeRole")
 *                     )))
 *                 )))
 *             .build());
 *         var testRolePolicyAttachment = new RolePolicyAttachment("testRolePolicyAttachment", RolePolicyAttachmentArgs.builder()
 *             .role(testRole.name())
 *             .policyArn("arn:aws:iam::aws:policy/service-role/AWSShieldDRTAccessPolicy")
 *             .build());
 *         var testDrtAccessRoleArnAssociation = new DrtAccessRoleArnAssociation("testDrtAccessRoleArnAssociation", DrtAccessRoleArnAssociationArgs.builder()
 *             .roleArn(testRole.arn())
 *             .build());
 *     }
 * }
 * ```
 */
public class DrtAccessRoleArnAssociation internal constructor(
    override val javaResource: com.pulumi.aws.shield.DrtAccessRoleArnAssociation,
) : KotlinCustomResource(javaResource, DrtAccessRoleArnAssociationMapper) {
    /**
     * The Amazon Resource Name (ARN) of the role the SRT will use to access your AWS account. Prior to making the AssociateDRTRole request, you must attach the `AWSShieldDRTAccessPolicy` managed policy to this role.
     */
    public val roleArn: Output<String>
        get() = javaResource.roleArn().applyValue({ args0 -> args0 })

    public val timeouts: Output<DrtAccessRoleArnAssociationTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })
}

public object DrtAccessRoleArnAssociationMapper : ResourceMapper<DrtAccessRoleArnAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.shield.DrtAccessRoleArnAssociation::class == javaResource::class

    override fun map(javaResource: Resource): DrtAccessRoleArnAssociation =
        DrtAccessRoleArnAssociation(javaResource as com.pulumi.aws.shield.DrtAccessRoleArnAssociation)
}

/**
 * @see [DrtAccessRoleArnAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DrtAccessRoleArnAssociation].
 */
public suspend fun drtAccessRoleArnAssociation(
    name: String,
    block: suspend DrtAccessRoleArnAssociationResourceBuilder.() -> Unit,
):
    DrtAccessRoleArnAssociation {
    val builder = DrtAccessRoleArnAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DrtAccessRoleArnAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun drtAccessRoleArnAssociation(name: String): DrtAccessRoleArnAssociation {
    val builder = DrtAccessRoleArnAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
