@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.shield.kotlin

import com.pulumi.aws.shield.DrtAccessRoleArnAssociationArgs.builder
import com.pulumi.aws.shield.kotlin.inputs.DrtAccessRoleArnAssociationTimeoutsArgs
import com.pulumi.aws.shield.kotlin.inputs.DrtAccessRoleArnAssociationTimeoutsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Authorizes the Shield Response Team (SRT) using the specified role, to access your AWS account to assist with DDoS attack mitigation during potential attacks. For more information see [Configure AWS SRT Support](https://docs.aws.amazon.com/waf/latest/developerguide/authorize-srt.html)
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.shield.DrtAccessRoleArnAssociation;
 * import com.pulumi.aws.shield.DrtAccessRoleArnAssociationArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testRole = new Role("testRole", RoleArgs.builder()
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Sid", ""),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("Service", "drt.shield.amazonaws.com")
 *                         )),
 *                         jsonProperty("Action", "sts:AssumeRole")
 *                     )))
 *                 )))
 *             .build());
 *         var testRolePolicyAttachment = new RolePolicyAttachment("testRolePolicyAttachment", RolePolicyAttachmentArgs.builder()
 *             .role(testRole.name())
 *             .policyArn("arn:aws:iam::aws:policy/service-role/AWSShieldDRTAccessPolicy")
 *             .build());
 *         var testDrtAccessRoleArnAssociation = new DrtAccessRoleArnAssociation("testDrtAccessRoleArnAssociation", DrtAccessRoleArnAssociationArgs.builder()
 *             .roleArn(testRole.arn())
 *             .build());
 *     }
 * }
 * ```
 * @property roleArn The Amazon Resource Name (ARN) of the role the SRT will use to access your AWS account. Prior to making the AssociateDRTRole request, you must attach the `AWSShieldDRTAccessPolicy` managed policy to this role.
 * @property timeouts
 */
public data class DrtAccessRoleArnAssociationArgs(
    public val roleArn: Output<String>? = null,
    public val timeouts: Output<DrtAccessRoleArnAssociationTimeoutsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.shield.DrtAccessRoleArnAssociationArgs> {
    override fun toJava(): com.pulumi.aws.shield.DrtAccessRoleArnAssociationArgs =
        com.pulumi.aws.shield.DrtAccessRoleArnAssociationArgs.builder()
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DrtAccessRoleArnAssociationArgs].
 */
@PulumiTagMarker
public class DrtAccessRoleArnAssociationArgsBuilder internal constructor() {
    private var roleArn: Output<String>? = null

    private var timeouts: Output<DrtAccessRoleArnAssociationTimeoutsArgs>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the role the SRT will use to access your AWS account. Prior to making the AssociateDRTRole request, you must attach the `AWSShieldDRTAccessPolicy` managed policy to this role.
     */
    @JvmName("rffbnxppknwpwgnh")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value
     */
    @JvmName("uqqkmynsqsmwfeph")
    public suspend fun timeouts(`value`: Output<DrtAccessRoleArnAssociationTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the role the SRT will use to access your AWS account. Prior to making the AssociateDRTRole request, you must attach the `AWSShieldDRTAccessPolicy` managed policy to this role.
     */
    @JvmName("aqetmglqafkttqos")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value
     */
    @JvmName("dunwwyiwnjkmcrwl")
    public suspend fun timeouts(`value`: DrtAccessRoleArnAssociationTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("vmiwrrwcrogjbnfg")
    public suspend
    fun timeouts(argument: suspend DrtAccessRoleArnAssociationTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = DrtAccessRoleArnAssociationTimeoutsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    internal fun build(): DrtAccessRoleArnAssociationArgs = DrtAccessRoleArnAssociationArgs(
        roleArn = roleArn,
        timeouts = timeouts,
    )
}
