@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.shield.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Protection].
 */
@PulumiTagMarker
public class ProtectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProtectionArgs = ProtectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProtectionArgsBuilder.() -> Unit) {
        val builder = ProtectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Protection {
        val builtJavaResource = com.pulumi.aws.shield.Protection(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Protection(builtJavaResource)
    }
}

/**
 * Enables AWS Shield Advanced for a specific AWS resource.
 * The resource can be an Amazon CloudFront distribution, Elastic Load Balancing load balancer, AWS Global Accelerator accelerator, Elastic IP Address, or an Amazon Route 53 hosted zone.
 * ## Example Usage
 * ### Create protection
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.ec2.Eip;
 * import com.pulumi.aws.ec2.EipArgs;
 * import com.pulumi.aws.shield.Protection;
 * import com.pulumi.aws.shield.ProtectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var available = AwsFunctions.getAvailabilityZones();
 *         final var currentRegion = AwsFunctions.getRegion();
 *         final var currentCallerIdentity = AwsFunctions.getCallerIdentity();
 *         var exampleEip = new Eip("exampleEip", EipArgs.builder()
 *             .domain("vpc")
 *             .build());
 *         var exampleProtection = new Protection("exampleProtection", ProtectionArgs.builder()
 *             .resourceArn(exampleEip.id().applyValue(id -> String.format("arn:aws:ec2:%s:%s:eip-allocation/%s", currentRegion.applyValue(getRegionResult -> getRegionResult.name()),currentCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()),id)))
 *             .tags(Map.of("Environment", "Dev"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Shield protection resources using specifying their ID. For example:
 * ```sh
 *  $ pulumi import aws:shield/protection:Protection example ff9592dc-22f3-4e88-afa1-7b29fde9669a
 * ```
 *
 */
public class Protection internal constructor(
    override val javaResource: com.pulumi.aws.shield.Protection,
) : KotlinCustomResource(javaResource, ProtectionMapper) {
    /**
     * The ARN of the Protection.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A friendly name for the Protection you are creating.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The ARN (Amazon Resource Name) of the resource to be protected.
     */
    public val resourceArn: Output<String>
        get() = javaResource.resourceArn().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ProtectionMapper : ResourceMapper<Protection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.shield.Protection::class == javaResource::class

    override fun map(javaResource: Resource): Protection = Protection(
        javaResource as
            com.pulumi.aws.shield.Protection,
    )
}

/**
 * @see [Protection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Protection].
 */
public suspend fun protection(name: String, block: suspend ProtectionResourceBuilder.() -> Unit):
    Protection {
    val builder = ProtectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Protection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun protection(name: String): Protection {
    val builder = ProtectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
