@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.shield.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [ProtectionGroup].
 */
@PulumiTagMarker
public class ProtectionGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProtectionGroupArgs = ProtectionGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProtectionGroupArgsBuilder.() -> Unit) {
        val builder = ProtectionGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ProtectionGroup {
        val builtJavaResource = com.pulumi.aws.shield.ProtectionGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ProtectionGroup(builtJavaResource)
    }
}

/**
 * Creates a grouping of protected resources so they can be handled as a collective.
 * This resource grouping improves the accuracy of detection and reduces false positives. For more information see
 * [Managing AWS Shield Advanced protection groups](https://docs.aws.amazon.com/waf/latest/developerguide/manage-protection-group.html)
 * ## Example Usage
 * ### Create protection group for all resources
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.shield.ProtectionGroup;
 * import com.pulumi.aws.shield.ProtectionGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ProtectionGroup("example", ProtectionGroupArgs.builder()
 *             .aggregation("MAX")
 *             .pattern("ALL")
 *             .protectionGroupId("example")
 *             .build());
 *     }
 * }
 * ```
 * ### Create protection group for arbitrary number of resources
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.ec2.Eip;
 * import com.pulumi.aws.ec2.EipArgs;
 * import com.pulumi.aws.shield.Protection;
 * import com.pulumi.aws.shield.ProtectionArgs;
 * import com.pulumi.aws.shield.ProtectionGroup;
 * import com.pulumi.aws.shield.ProtectionGroupArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var currentRegion = AwsFunctions.getRegion();
 *         final var currentCallerIdentity = AwsFunctions.getCallerIdentity();
 *         var exampleEip = new Eip("exampleEip", EipArgs.builder()
 *             .domain("vpc")
 *             .build());
 *         var exampleProtection = new Protection("exampleProtection", ProtectionArgs.builder()
 *             .resourceArn(exampleEip.id().applyValue(id -> String.format("arn:aws:ec2:%s:%s:eip-allocation/%s", currentRegion.applyValue(getRegionResult -> getRegionResult.name()),currentCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()),id)))
 *             .build());
 *         var exampleProtectionGroup = new ProtectionGroup("exampleProtectionGroup", ProtectionGroupArgs.builder()
 *             .protectionGroupId("example")
 *             .aggregation("MEAN")
 *             .pattern("ARBITRARY")
 *             .members(exampleEip.id().applyValue(id -> String.format("arn:aws:ec2:%s:%s:eip-allocation/%s", currentRegion.applyValue(getRegionResult -> getRegionResult.name()),currentCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()),id)))
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleProtection)
 *                 .build());
 *     }
 * }
 * ```
 * ### Create protection group for a type of resource
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.shield.ProtectionGroup;
 * import com.pulumi.aws.shield.ProtectionGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ProtectionGroup("example", ProtectionGroupArgs.builder()
 *             .aggregation("SUM")
 *             .pattern("BY_RESOURCE_TYPE")
 *             .protectionGroupId("example")
 *             .resourceType("ELASTIC_IP_ALLOCATION")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Shield protection group resources using their protection group id. For example:
 * ```sh
 *  $ pulumi import aws:shield/protectionGroup:ProtectionGroup example example
 * ```
 *
 */
public class ProtectionGroup internal constructor(
    override val javaResource: com.pulumi.aws.shield.ProtectionGroup,
) : KotlinCustomResource(javaResource, ProtectionGroupMapper) {
    /**
     * Defines how AWS Shield combines resource data for the group in order to detect, mitigate, and report events.
     */
    public val aggregation: Output<String>
        get() = javaResource.aggregation().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Names (ARNs) of the resources to include in the protection group. You must set this when you set `pattern` to ARBITRARY and you must not set it for any other `pattern` setting.
     */
    public val members: Output<List<String>>?
        get() = javaResource.members().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The criteria to use to choose the protected resources for inclusion in the group.
     */
    public val pattern: Output<String>
        get() = javaResource.pattern().applyValue({ args0 -> args0 })

    /**
     * The ARN (Amazon Resource Name) of the protection group.
     */
    public val protectionGroupArn: Output<String>
        get() = javaResource.protectionGroupArn().applyValue({ args0 -> args0 })

    /**
     * The name of the protection group.
     */
    public val protectionGroupId: Output<String>
        get() = javaResource.protectionGroupId().applyValue({ args0 -> args0 })

    /**
     * The resource type to include in the protection group. You must set this when you set `pattern` to BY_RESOURCE_TYPE and you must not set it for any other `pattern` setting.
     */
    public val resourceType: Output<String>?
        get() = javaResource.resourceType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ProtectionGroupMapper : ResourceMapper<ProtectionGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.shield.ProtectionGroup::class == javaResource::class

    override fun map(javaResource: Resource): ProtectionGroup = ProtectionGroup(
        javaResource as
            com.pulumi.aws.shield.ProtectionGroup,
    )
}

/**
 * @see [ProtectionGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProtectionGroup].
 */
public suspend fun protectionGroup(
    name: String,
    block: suspend ProtectionGroupResourceBuilder.() -> Unit,
): ProtectionGroup {
    val builder = ProtectionGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProtectionGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun protectionGroup(name: String): ProtectionGroup {
    val builder = ProtectionGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
