@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.shield.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ProtectionHealthCheckAssociation].
 */
@PulumiTagMarker
public class ProtectionHealthCheckAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProtectionHealthCheckAssociationArgs = ProtectionHealthCheckAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProtectionHealthCheckAssociationArgsBuilder.() -> Unit) {
        val builder = ProtectionHealthCheckAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ProtectionHealthCheckAssociation {
        val builtJavaResource =
            com.pulumi.aws.shield.ProtectionHealthCheckAssociation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ProtectionHealthCheckAssociation(builtJavaResource)
    }
}

/**
 * Creates an association between a Route53 Health Check and a Shield Advanced protected resource.
 * This association uses the health of your applications to improve responsiveness and accuracy in attack detection and mitigation.
 * Blog post: [AWS Shield Advanced now supports Health Based Detection](https://aws.amazon.com/about-aws/whats-new/2020/02/aws-shield-advanced-now-supports-health-based-detection/)
 * ## Example Usage
 * ### Create an association between a protected EIP and a Route53 Health Check
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.inputs.GetPartitionArgs;
 * import com.pulumi.aws.ec2.Eip;
 * import com.pulumi.aws.ec2.EipArgs;
 * import com.pulumi.aws.shield.Protection;
 * import com.pulumi.aws.shield.ProtectionArgs;
 * import com.pulumi.aws.route53.HealthCheck;
 * import com.pulumi.aws.route53.HealthCheckArgs;
 * import com.pulumi.aws.shield.ProtectionHealthCheckAssociation;
 * import com.pulumi.aws.shield.ProtectionHealthCheckAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var currentRegion = AwsFunctions.getRegion();
 *         final var currentCallerIdentity = AwsFunctions.getCallerIdentity();
 *         final var currentPartition = AwsFunctions.getPartition();
 *         var exampleEip = new Eip("exampleEip", EipArgs.builder()
 *             .domain("vpc")
 *             .tags(Map.of("Name", "example"))
 *             .build());
 *         var exampleProtection = new Protection("exampleProtection", ProtectionArgs.builder()
 *             .resourceArn(exampleEip.id().applyValue(id -> String.format("arn:%s:ec2:%s:%s:eip-allocation/%s", currentPartition.applyValue(getPartitionResult -> getPartitionResult.partition()),currentRegion.applyValue(getRegionResult -> getRegionResult.name()),currentCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()),id)))
 *             .build());
 *         var exampleHealthCheck = new HealthCheck("exampleHealthCheck", HealthCheckArgs.builder()
 *             .ipAddress(exampleEip.publicIp())
 *             .port(80)
 *             .type("HTTP")
 *             .resourcePath("/ready")
 *             .failureThreshold("3")
 *             .requestInterval("30")
 *             .tags(Map.of("Name", "tf-example-health-check"))
 *             .build());
 *         var exampleProtectionHealthCheckAssociation = new ProtectionHealthCheckAssociation("exampleProtectionHealthCheckAssociation", ProtectionHealthCheckAssociationArgs.builder()
 *             .healthCheckArn(exampleHealthCheck.arn())
 *             .shieldProtectionId(exampleProtection.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Shield protection health check association resources using the `shield_protection_id` and `health_check_arn`. For example:
 * ```sh
 *  $ pulumi import aws:shield/protectionHealthCheckAssociation:ProtectionHealthCheckAssociation example ff9592dc-22f3-4e88-afa1-7b29fde9669a+arn:aws:route53:::healthcheck/3742b175-edb9-46bc-9359-f53e3b794b1b
 * ```
 *
 */
public class ProtectionHealthCheckAssociation internal constructor(
    override val javaResource: com.pulumi.aws.shield.ProtectionHealthCheckAssociation,
) : KotlinCustomResource(javaResource, ProtectionHealthCheckAssociationMapper) {
    /**
     * The ARN (Amazon Resource Name) of the Route53 Health Check resource which will be associated to the protected resource.
     */
    public val healthCheckArn: Output<String>
        get() = javaResource.healthCheckArn().applyValue({ args0 -> args0 })

    /**
     * The ID of the protected resource.
     */
    public val shieldProtectionId: Output<String>
        get() = javaResource.shieldProtectionId().applyValue({ args0 -> args0 })
}

public object ProtectionHealthCheckAssociationMapper :
    ResourceMapper<ProtectionHealthCheckAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.shield.ProtectionHealthCheckAssociation::class == javaResource::class

    override fun map(javaResource: Resource): ProtectionHealthCheckAssociation =
        ProtectionHealthCheckAssociation(
            javaResource as
                com.pulumi.aws.shield.ProtectionHealthCheckAssociation,
        )
}

/**
 * @see [ProtectionHealthCheckAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProtectionHealthCheckAssociation].
 */
public suspend fun protectionHealthCheckAssociation(
    name: String,
    block: suspend ProtectionHealthCheckAssociationResourceBuilder.() -> Unit,
):
    ProtectionHealthCheckAssociation {
    val builder = ProtectionHealthCheckAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProtectionHealthCheckAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun protectionHealthCheckAssociation(name: String): ProtectionHealthCheckAssociation {
    val builder = ProtectionHealthCheckAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
