@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.shield.kotlin

import com.pulumi.aws.shield.ProtectionHealthCheckAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Creates an association between a Route53 Health Check and a Shield Advanced protected resource.
 * This association uses the health of your applications to improve responsiveness and accuracy in attack detection and mitigation.
 * Blog post: [AWS Shield Advanced now supports Health Based Detection](https://aws.amazon.com/about-aws/whats-new/2020/02/aws-shield-advanced-now-supports-health-based-detection/)
 * ## Example Usage
 * ### Create an association between a protected EIP and a Route53 Health Check
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.inputs.GetPartitionArgs;
 * import com.pulumi.aws.ec2.Eip;
 * import com.pulumi.aws.ec2.EipArgs;
 * import com.pulumi.aws.shield.Protection;
 * import com.pulumi.aws.shield.ProtectionArgs;
 * import com.pulumi.aws.route53.HealthCheck;
 * import com.pulumi.aws.route53.HealthCheckArgs;
 * import com.pulumi.aws.shield.ProtectionHealthCheckAssociation;
 * import com.pulumi.aws.shield.ProtectionHealthCheckAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var currentRegion = AwsFunctions.getRegion();
 *         final var currentCallerIdentity = AwsFunctions.getCallerIdentity();
 *         final var currentPartition = AwsFunctions.getPartition();
 *         var exampleEip = new Eip("exampleEip", EipArgs.builder()
 *             .domain("vpc")
 *             .tags(Map.of("Name", "example"))
 *             .build());
 *         var exampleProtection = new Protection("exampleProtection", ProtectionArgs.builder()
 *             .resourceArn(exampleEip.id().applyValue(id -> String.format("arn:%s:ec2:%s:%s:eip-allocation/%s", currentPartition.applyValue(getPartitionResult -> getPartitionResult.partition()),currentRegion.applyValue(getRegionResult -> getRegionResult.name()),currentCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()),id)))
 *             .build());
 *         var exampleHealthCheck = new HealthCheck("exampleHealthCheck", HealthCheckArgs.builder()
 *             .ipAddress(exampleEip.publicIp())
 *             .port(80)
 *             .type("HTTP")
 *             .resourcePath("/ready")
 *             .failureThreshold("3")
 *             .requestInterval("30")
 *             .tags(Map.of("Name", "tf-example-health-check"))
 *             .build());
 *         var exampleProtectionHealthCheckAssociation = new ProtectionHealthCheckAssociation("exampleProtectionHealthCheckAssociation", ProtectionHealthCheckAssociationArgs.builder()
 *             .healthCheckArn(exampleHealthCheck.arn())
 *             .shieldProtectionId(exampleProtection.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Shield protection health check association resources using the `shield_protection_id` and `health_check_arn`. For example:
 * ```sh
 *  $ pulumi import aws:shield/protectionHealthCheckAssociation:ProtectionHealthCheckAssociation example ff9592dc-22f3-4e88-afa1-7b29fde9669a+arn:aws:route53:::healthcheck/3742b175-edb9-46bc-9359-f53e3b794b1b
 * ```
 * @property healthCheckArn The ARN (Amazon Resource Name) of the Route53 Health Check resource which will be associated to the protected resource.
 * @property shieldProtectionId The ID of the protected resource.
 */
public data class ProtectionHealthCheckAssociationArgs(
    public val healthCheckArn: Output<String>? = null,
    public val shieldProtectionId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.shield.ProtectionHealthCheckAssociationArgs> {
    override fun toJava(): com.pulumi.aws.shield.ProtectionHealthCheckAssociationArgs =
        com.pulumi.aws.shield.ProtectionHealthCheckAssociationArgs.builder()
            .healthCheckArn(healthCheckArn?.applyValue({ args0 -> args0 }))
            .shieldProtectionId(shieldProtectionId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProtectionHealthCheckAssociationArgs].
 */
@PulumiTagMarker
public class ProtectionHealthCheckAssociationArgsBuilder internal constructor() {
    private var healthCheckArn: Output<String>? = null

    private var shieldProtectionId: Output<String>? = null

    /**
     * @param value The ARN (Amazon Resource Name) of the Route53 Health Check resource which will be associated to the protected resource.
     */
    @JvmName("njpmohlcgwttyybp")
    public suspend fun healthCheckArn(`value`: Output<String>) {
        this.healthCheckArn = value
    }

    /**
     * @param value The ID of the protected resource.
     */
    @JvmName("siwewcjdliaguqel")
    public suspend fun shieldProtectionId(`value`: Output<String>) {
        this.shieldProtectionId = value
    }

    /**
     * @param value The ARN (Amazon Resource Name) of the Route53 Health Check resource which will be associated to the protected resource.
     */
    @JvmName("vhsperdorbgjbuqx")
    public suspend fun healthCheckArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckArn = mapped
    }

    /**
     * @param value The ID of the protected resource.
     */
    @JvmName("sloycdtiybwmplgj")
    public suspend fun shieldProtectionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shieldProtectionId = mapped
    }

    internal fun build(): ProtectionHealthCheckAssociationArgs = ProtectionHealthCheckAssociationArgs(
        healthCheckArn = healthCheckArn,
        shieldProtectionId = shieldProtectionId,
    )
}
