@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.shield.kotlin.inputs

import com.pulumi.aws.shield.inputs.ApplicationLayerAutomaticResponseTimeoutsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property create
 * @property delete
 * @property update
 */
public data class ApplicationLayerAutomaticResponseTimeoutsArgs(
    public val create: Output<String>? = null,
    public val delete: Output<String>? = null,
    public val update: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.shield.inputs.ApplicationLayerAutomaticResponseTimeoutsArgs> {
    override fun toJava(): com.pulumi.aws.shield.inputs.ApplicationLayerAutomaticResponseTimeoutsArgs =
        com.pulumi.aws.shield.inputs.ApplicationLayerAutomaticResponseTimeoutsArgs.builder()
            .create(create?.applyValue({ args0 -> args0 }))
            .delete(delete?.applyValue({ args0 -> args0 }))
            .update(update?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationLayerAutomaticResponseTimeoutsArgs].
 */
@PulumiTagMarker
public class ApplicationLayerAutomaticResponseTimeoutsArgsBuilder internal constructor() {
    private var create: Output<String>? = null

    private var delete: Output<String>? = null

    private var update: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("egsyifabrklxduvl")
    public suspend fun create(`value`: Output<String>) {
        this.create = value
    }

    /**
     * @param value
     */
    @JvmName("clxnujqcvrqloclv")
    public suspend fun delete(`value`: Output<String>) {
        this.delete = value
    }

    /**
     * @param value
     */
    @JvmName("lgddgxriygljcfkc")
    public suspend fun update(`value`: Output<String>) {
        this.update = value
    }

    /**
     * @param value
     */
    @JvmName("oanaiwjuqrsvhkxf")
    public suspend fun create(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.create = mapped
    }

    /**
     * @param value
     */
    @JvmName("pknkovjiynsjbnoj")
    public suspend fun delete(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.delete = mapped
    }

    /**
     * @param value
     */
    @JvmName("imprmufgmjsrlayc")
    public suspend fun update(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.update = mapped
    }

    internal fun build(): ApplicationLayerAutomaticResponseTimeoutsArgs =
        ApplicationLayerAutomaticResponseTimeoutsArgs(
            create = create,
            delete = delete,
            update = update,
        )
}
