@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.shield.kotlin.inputs

import com.pulumi.aws.shield.inputs.DrtAccessLogBucketAssociationTimeoutsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property create
 * @property delete
 * @property read
 */
public data class DrtAccessLogBucketAssociationTimeoutsArgs(
    public val create: Output<String>? = null,
    public val delete: Output<String>? = null,
    public val read: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.shield.inputs.DrtAccessLogBucketAssociationTimeoutsArgs> {
    override fun toJava(): com.pulumi.aws.shield.inputs.DrtAccessLogBucketAssociationTimeoutsArgs =
        com.pulumi.aws.shield.inputs.DrtAccessLogBucketAssociationTimeoutsArgs.builder()
            .create(create?.applyValue({ args0 -> args0 }))
            .delete(delete?.applyValue({ args0 -> args0 }))
            .read(read?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DrtAccessLogBucketAssociationTimeoutsArgs].
 */
@PulumiTagMarker
public class DrtAccessLogBucketAssociationTimeoutsArgsBuilder internal constructor() {
    private var create: Output<String>? = null

    private var delete: Output<String>? = null

    private var read: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("tnexmxaexhiqtsls")
    public suspend fun create(`value`: Output<String>) {
        this.create = value
    }

    /**
     * @param value
     */
    @JvmName("udsfvwteqmytjmfw")
    public suspend fun delete(`value`: Output<String>) {
        this.delete = value
    }

    /**
     * @param value
     */
    @JvmName("lapkvvtygjkualnc")
    public suspend fun read(`value`: Output<String>) {
        this.read = value
    }

    /**
     * @param value
     */
    @JvmName("aumvyesvgdbmgnkp")
    public suspend fun create(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.create = mapped
    }

    /**
     * @param value
     */
    @JvmName("xcbjpcxvbpixkoib")
    public suspend fun delete(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.delete = mapped
    }

    /**
     * @param value
     */
    @JvmName("yahoptotukphwnop")
    public suspend fun read(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.read = mapped
    }

    internal fun build(): DrtAccessLogBucketAssociationTimeoutsArgs =
        DrtAccessLogBucketAssociationTimeoutsArgs(
            create = create,
            delete = delete,
            read = read,
        )
}
