@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.shield.kotlin.inputs

import com.pulumi.aws.shield.inputs.DrtAccessRoleArnAssociationTimeoutsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property create
 * @property delete
 * @property read
 */
public data class DrtAccessRoleArnAssociationTimeoutsArgs(
    public val create: Output<String>? = null,
    public val delete: Output<String>? = null,
    public val read: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.shield.inputs.DrtAccessRoleArnAssociationTimeoutsArgs> {
    override fun toJava(): com.pulumi.aws.shield.inputs.DrtAccessRoleArnAssociationTimeoutsArgs =
        com.pulumi.aws.shield.inputs.DrtAccessRoleArnAssociationTimeoutsArgs.builder()
            .create(create?.applyValue({ args0 -> args0 }))
            .delete(delete?.applyValue({ args0 -> args0 }))
            .read(read?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DrtAccessRoleArnAssociationTimeoutsArgs].
 */
@PulumiTagMarker
public class DrtAccessRoleArnAssociationTimeoutsArgsBuilder internal constructor() {
    private var create: Output<String>? = null

    private var delete: Output<String>? = null

    private var read: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("sujjrmvfjoplpqoo")
    public suspend fun create(`value`: Output<String>) {
        this.create = value
    }

    /**
     * @param value
     */
    @JvmName("xnrlqssnwykjmjyf")
    public suspend fun delete(`value`: Output<String>) {
        this.delete = value
    }

    /**
     * @param value
     */
    @JvmName("oeqhqyjcddpbjpmf")
    public suspend fun read(`value`: Output<String>) {
        this.read = value
    }

    /**
     * @param value
     */
    @JvmName("vpjklnmwfbfjyfna")
    public suspend fun create(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.create = mapped
    }

    /**
     * @param value
     */
    @JvmName("cqmtwejjfriacetl")
    public suspend fun delete(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.delete = mapped
    }

    /**
     * @param value
     */
    @JvmName("brtekxsiqxnwfuxs")
    public suspend fun read(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.read = mapped
    }

    internal fun build(): DrtAccessRoleArnAssociationTimeoutsArgs =
        DrtAccessRoleArnAssociationTimeoutsArgs(
            create = create,
            delete = delete,
            read = read,
        )
}
