@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.signer.kotlin

import com.pulumi.aws.signer.SignerFunctions.getSigningJobPlain
import com.pulumi.aws.signer.SignerFunctions.getSigningProfilePlain
import com.pulumi.aws.signer.kotlin.inputs.GetSigningJobPlainArgs
import com.pulumi.aws.signer.kotlin.inputs.GetSigningJobPlainArgsBuilder
import com.pulumi.aws.signer.kotlin.inputs.GetSigningProfilePlainArgs
import com.pulumi.aws.signer.kotlin.inputs.GetSigningProfilePlainArgsBuilder
import com.pulumi.aws.signer.kotlin.outputs.GetSigningJobResult
import com.pulumi.aws.signer.kotlin.outputs.GetSigningProfileResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.signer.kotlin.outputs.GetSigningJobResult.Companion.toKotlin as getSigningJobResultToKotlin
import com.pulumi.aws.signer.kotlin.outputs.GetSigningProfileResult.Companion.toKotlin as getSigningProfileResultToKotlin

public object SignerFunctions {
    /**
     * Provides information about a Signer Signing Job.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.signer.SignerFunctions;
     * import com.pulumi.aws.signer.inputs.GetSigningJobArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var buildSigningJob = SignerFunctions.getSigningJob(GetSigningJobArgs.builder()
     *             .jobId("9ed7e5c3-b8d4-4da0-8459-44e0b068f7ee")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getSigningJob.
     * @return A collection of values returned by getSigningJob.
     */
    public suspend fun getSigningJob(argument: GetSigningJobPlainArgs): GetSigningJobResult =
        getSigningJobResultToKotlin(getSigningJobPlain(argument.toJava()).await())

    /**
     * @see [getSigningJob].
     * @param jobId ID of the signing job on output.
     * @return A collection of values returned by getSigningJob.
     */
    public suspend fun getSigningJob(jobId: String): GetSigningJobResult {
        val argument = GetSigningJobPlainArgs(
            jobId = jobId,
        )
        return getSigningJobResultToKotlin(getSigningJobPlain(argument.toJava()).await())
    }

    /**
     * @see [getSigningJob].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;signer&#46;kotlin&#46;inputs&#46;GetSigningJobPlainArgs].
     * @return A collection of values returned by getSigningJob.
     */
    public suspend fun getSigningJob(argument: suspend GetSigningJobPlainArgsBuilder.() -> Unit):
        GetSigningJobResult {
        val builder = GetSigningJobPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSigningJobResultToKotlin(getSigningJobPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides information about a Signer Signing Profile.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.signer.SignerFunctions;
     * import com.pulumi.aws.signer.inputs.GetSigningProfileArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var productionSigningProfile = SignerFunctions.getSigningProfile(GetSigningProfileArgs.builder()
     *             .name("prod_profile_DdW3Mk1foYL88fajut4mTVFGpuwfd4ACO6ANL0D1uIj7lrn8adK")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getSigningProfile.
     * @return A collection of values returned by getSigningProfile.
     */
    public suspend fun getSigningProfile(argument: GetSigningProfilePlainArgs):
        GetSigningProfileResult =
        getSigningProfileResultToKotlin(getSigningProfilePlain(argument.toJava()).await())

    /**
     * @see [getSigningProfile].
     * @param name Name of the target signing profile.
     * @param tags List of tags associated with the signing profile.
     * @return A collection of values returned by getSigningProfile.
     */
    public suspend fun getSigningProfile(name: String, tags: Map<String, String>? = null):
        GetSigningProfileResult {
        val argument = GetSigningProfilePlainArgs(
            name = name,
            tags = tags,
        )
        return getSigningProfileResultToKotlin(getSigningProfilePlain(argument.toJava()).await())
    }

    /**
     * @see [getSigningProfile].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;signer&#46;kotlin&#46;inputs&#46;GetSigningProfilePlainArgs].
     * @return A collection of values returned by getSigningProfile.
     */
    public suspend
    fun getSigningProfile(argument: suspend GetSigningProfilePlainArgsBuilder.() -> Unit):
        GetSigningProfileResult {
        val builder = GetSigningProfilePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSigningProfileResultToKotlin(getSigningProfilePlain(builtArgument.toJava()).await())
    }
}
