@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.signer.kotlin

import com.pulumi.aws.signer.SigningJobArgs.builder
import com.pulumi.aws.signer.kotlin.inputs.SigningJobDestinationArgs
import com.pulumi.aws.signer.kotlin.inputs.SigningJobDestinationArgsBuilder
import com.pulumi.aws.signer.kotlin.inputs.SigningJobSourceArgs
import com.pulumi.aws.signer.kotlin.inputs.SigningJobSourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Creates a Signer Signing Job.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.signer.SigningProfile;
 * import com.pulumi.aws.signer.SigningProfileArgs;
 * import com.pulumi.aws.signer.SigningJob;
 * import com.pulumi.aws.signer.SigningJobArgs;
 * import com.pulumi.aws.signer.inputs.SigningJobSourceArgs;
 * import com.pulumi.aws.signer.inputs.SigningJobSourceS3Args;
 * import com.pulumi.aws.signer.inputs.SigningJobDestinationArgs;
 * import com.pulumi.aws.signer.inputs.SigningJobDestinationS3Args;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testSp = new SigningProfile("testSp", SigningProfileArgs.builder()
 *             .platformId("AWSLambda-SHA384-ECDSA")
 *             .build());
 *         var buildSigningJob = new SigningJob("buildSigningJob", SigningJobArgs.builder()
 *             .profileName(testSp.name())
 *             .source(SigningJobSourceArgs.builder()
 *                 .s3(SigningJobSourceS3Args.builder()
 *                     .bucket("s3-bucket-name")
 *                     .key("object-to-be-signed.zip")
 *                     .version("jADjFYYYEXAMPLETszPjOmCMFDzd9dN1")
 *                     .build())
 *                 .build())
 *             .destination(SigningJobDestinationArgs.builder()
 *                 .s3(SigningJobDestinationS3Args.builder()
 *                     .bucket("s3-bucket-name")
 *                     .prefix("signed/")
 *                     .build())
 *                 .build())
 *             .ignoreSigningJobFailure(true)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Signer signing jobs using the `job_id`. For example:
 * ```sh
 *  $ pulumi import aws:signer/signingJob:SigningJob test_signer_signing_job 9ed7e5c3-b8d4-4da0-8459-44e0b068f7ee
 * ```
 * @property destination The S3 bucket in which to save your signed object. See Destination below for details.
 * @property ignoreSigningJobFailure Set this argument to `true` to ignore signing job failures and retrieve failed status and reason. Default `false`.
 * @property profileName The name of the profile to initiate the signing operation.
 * @property source The S3 bucket that contains the object to sign. See Source below for details.
 */
public data class SigningJobArgs(
    public val destination: Output<SigningJobDestinationArgs>? = null,
    public val ignoreSigningJobFailure: Output<Boolean>? = null,
    public val profileName: Output<String>? = null,
    public val source: Output<SigningJobSourceArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.signer.SigningJobArgs> {
    override fun toJava(): com.pulumi.aws.signer.SigningJobArgs =
        com.pulumi.aws.signer.SigningJobArgs.builder()
            .destination(destination?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ignoreSigningJobFailure(ignoreSigningJobFailure?.applyValue({ args0 -> args0 }))
            .profileName(profileName?.applyValue({ args0 -> args0 }))
            .source(source?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [SigningJobArgs].
 */
@PulumiTagMarker
public class SigningJobArgsBuilder internal constructor() {
    private var destination: Output<SigningJobDestinationArgs>? = null

    private var ignoreSigningJobFailure: Output<Boolean>? = null

    private var profileName: Output<String>? = null

    private var source: Output<SigningJobSourceArgs>? = null

    /**
     * @param value The S3 bucket in which to save your signed object. See Destination below for details.
     */
    @JvmName("ytjseoxqqypneqpt")
    public suspend fun destination(`value`: Output<SigningJobDestinationArgs>) {
        this.destination = value
    }

    /**
     * @param value Set this argument to `true` to ignore signing job failures and retrieve failed status and reason. Default `false`.
     */
    @JvmName("ubskgnrmomurttnk")
    public suspend fun ignoreSigningJobFailure(`value`: Output<Boolean>) {
        this.ignoreSigningJobFailure = value
    }

    /**
     * @param value The name of the profile to initiate the signing operation.
     */
    @JvmName("mbxhbyfbyoemcoah")
    public suspend fun profileName(`value`: Output<String>) {
        this.profileName = value
    }

    /**
     * @param value The S3 bucket that contains the object to sign. See Source below for details.
     */
    @JvmName("gjprofucxdlttvvw")
    public suspend fun source(`value`: Output<SigningJobSourceArgs>) {
        this.source = value
    }

    /**
     * @param value The S3 bucket in which to save your signed object. See Destination below for details.
     */
    @JvmName("tfwicudxnacjjjrg")
    public suspend fun destination(`value`: SigningJobDestinationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    /**
     * @param argument The S3 bucket in which to save your signed object. See Destination below for details.
     */
    @JvmName("hjejxvtiyiwhubff")
    public suspend fun destination(argument: suspend SigningJobDestinationArgsBuilder.() -> Unit) {
        val toBeMapped = SigningJobDestinationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.destination = mapped
    }

    /**
     * @param value Set this argument to `true` to ignore signing job failures and retrieve failed status and reason. Default `false`.
     */
    @JvmName("hhfxqlfkeluhjwoh")
    public suspend fun ignoreSigningJobFailure(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ignoreSigningJobFailure = mapped
    }

    /**
     * @param value The name of the profile to initiate the signing operation.
     */
    @JvmName("rrwvisdqqxqwpxwi")
    public suspend fun profileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.profileName = mapped
    }

    /**
     * @param value The S3 bucket that contains the object to sign. See Source below for details.
     */
    @JvmName("khmbjrxcdrgemiby")
    public suspend fun source(`value`: SigningJobSourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param argument The S3 bucket that contains the object to sign. See Source below for details.
     */
    @JvmName("jsqkwxnwmvxjprea")
    public suspend fun source(argument: suspend SigningJobSourceArgsBuilder.() -> Unit) {
        val toBeMapped = SigningJobSourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.source = mapped
    }

    internal fun build(): SigningJobArgs = SigningJobArgs(
        destination = destination,
        ignoreSigningJobFailure = ignoreSigningJobFailure,
        profileName = profileName,
        source = source,
    )
}
