@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.signer.kotlin

import com.pulumi.aws.signer.SigningProfileArgs.builder
import com.pulumi.aws.signer.kotlin.inputs.SigningProfileSignatureValidityPeriodArgs
import com.pulumi.aws.signer.kotlin.inputs.SigningProfileSignatureValidityPeriodArgsBuilder
import com.pulumi.aws.signer.kotlin.inputs.SigningProfileSigningMaterialArgs
import com.pulumi.aws.signer.kotlin.inputs.SigningProfileSigningMaterialArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Creates a Signer Signing Profile. A signing profile contains information about the code signing configuration parameters that can be used by a given code signing user.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.signer.SigningProfile;
 * import com.pulumi.aws.signer.SigningProfileArgs;
 * import com.pulumi.aws.signer.inputs.SigningProfileSignatureValidityPeriodArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testSp = new SigningProfile("testSp", SigningProfileArgs.builder()
 *             .platformId("AWSLambda-SHA384-ECDSA")
 *             .build());
 *         var prodSp = new SigningProfile("prodSp", SigningProfileArgs.builder()
 *             .namePrefix("prod_sp_")
 *             .platformId("AWSLambda-SHA384-ECDSA")
 *             .signatureValidityPeriod(SigningProfileSignatureValidityPeriodArgs.builder()
 *                 .type("YEARS")
 *                 .value(5)
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Signer signing profiles using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:signer/signingProfile:SigningProfile test_signer_signing_profile test_sp_DdW3Mk1foYL88fajut4mTVFGpuwfd4ACO6ANL0D1uIj7lrn8adK
 * ```
 * @property name A unique signing profile name. By default generated by the provider. Signing profile names are immutable and cannot be reused after canceled.
 * @property namePrefix A signing profile name prefix. The provider will generate a unique suffix. Conflicts with `name`.
 * @property platformId The ID of the platform that is used by the target signing profile.
 * @property signatureValidityPeriod The validity period for a signing job.
 * @property signingMaterial
 * @property tags A list of tags associated with the signing profile. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class SigningProfileArgs(
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val platformId: Output<String>? = null,
    public val signatureValidityPeriod: Output<SigningProfileSignatureValidityPeriodArgs>? = null,
    public val signingMaterial: Output<SigningProfileSigningMaterialArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.signer.SigningProfileArgs> {
    override fun toJava(): com.pulumi.aws.signer.SigningProfileArgs =
        com.pulumi.aws.signer.SigningProfileArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .platformId(platformId?.applyValue({ args0 -> args0 }))
            .signatureValidityPeriod(
                signatureValidityPeriod?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .signingMaterial(signingMaterial?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SigningProfileArgs].
 */
@PulumiTagMarker
public class SigningProfileArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var platformId: Output<String>? = null

    private var signatureValidityPeriod: Output<SigningProfileSignatureValidityPeriodArgs>? = null

    private var signingMaterial: Output<SigningProfileSigningMaterialArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A unique signing profile name. By default generated by the provider. Signing profile names are immutable and cannot be reused after canceled.
     */
    @JvmName("syswlwucdaipafya")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A signing profile name prefix. The provider will generate a unique suffix. Conflicts with `name`.
     */
    @JvmName("ciwaouufnoaysvee")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value The ID of the platform that is used by the target signing profile.
     */
    @JvmName("bujboyhnjsxlhryb")
    public suspend fun platformId(`value`: Output<String>) {
        this.platformId = value
    }

    /**
     * @param value The validity period for a signing job.
     */
    @JvmName("gxnqfeebljlqwqfv")
    public suspend
    fun signatureValidityPeriod(`value`: Output<SigningProfileSignatureValidityPeriodArgs>) {
        this.signatureValidityPeriod = value
    }

    /**
     * @param value
     */
    @JvmName("bsnlwqmbpderrukg")
    public suspend fun signingMaterial(`value`: Output<SigningProfileSigningMaterialArgs>) {
        this.signingMaterial = value
    }

    /**
     * @param value A list of tags associated with the signing profile. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fspcyagcqnrhwdri")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A unique signing profile name. By default generated by the provider. Signing profile names are immutable and cannot be reused after canceled.
     */
    @JvmName("pljeicgfemydyifv")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A signing profile name prefix. The provider will generate a unique suffix. Conflicts with `name`.
     */
    @JvmName("btoxnqbxicnuqxqa")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value The ID of the platform that is used by the target signing profile.
     */
    @JvmName("ulmkvpqqbsiqxwnm")
    public suspend fun platformId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.platformId = mapped
    }

    /**
     * @param value The validity period for a signing job.
     */
    @JvmName("rbjpgrbemyupnbhu")
    public suspend fun signatureValidityPeriod(`value`: SigningProfileSignatureValidityPeriodArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.signatureValidityPeriod = mapped
    }

    /**
     * @param argument The validity period for a signing job.
     */
    @JvmName("xeunktlmmdyyapbq")
    public suspend
    fun signatureValidityPeriod(argument: suspend SigningProfileSignatureValidityPeriodArgsBuilder.() -> Unit) {
        val toBeMapped = SigningProfileSignatureValidityPeriodArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.signatureValidityPeriod = mapped
    }

    /**
     * @param value
     */
    @JvmName("ompobokucdggssdq")
    public suspend fun signingMaterial(`value`: SigningProfileSigningMaterialArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.signingMaterial = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ounoiiktawrsgsed")
    public suspend
    fun signingMaterial(argument: suspend SigningProfileSigningMaterialArgsBuilder.() -> Unit) {
        val toBeMapped = SigningProfileSigningMaterialArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.signingMaterial = mapped
    }

    /**
     * @param value A list of tags associated with the signing profile. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ignhlhxrsbltdcvf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A list of tags associated with the signing profile. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mqiiwhdyrmqptcmk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SigningProfileArgs = SigningProfileArgs(
        name = name,
        namePrefix = namePrefix,
        platformId = platformId,
        signatureValidityPeriod = signatureValidityPeriod,
        signingMaterial = signingMaterial,
        tags = tags,
    )
}
