@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.signer.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SigningProfilePermission].
 */
@PulumiTagMarker
public class SigningProfilePermissionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SigningProfilePermissionArgs = SigningProfilePermissionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SigningProfilePermissionArgsBuilder.() -> Unit) {
        val builder = SigningProfilePermissionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SigningProfilePermission {
        val builtJavaResource = com.pulumi.aws.signer.SigningProfilePermission(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SigningProfilePermission(builtJavaResource)
    }
}

/**
 * Creates a Signer Signing Profile Permission. That is, a cross-account permission for a signing profile.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.signer.SigningProfile;
 * import com.pulumi.aws.signer.SigningProfileArgs;
 * import com.pulumi.aws.signer.inputs.SigningProfileSignatureValidityPeriodArgs;
 * import com.pulumi.aws.signer.SigningProfilePermission;
 * import com.pulumi.aws.signer.SigningProfilePermissionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var prodSp = new SigningProfile("prodSp", SigningProfileArgs.builder()
 *             .platformId("AWSLambda-SHA384-ECDSA")
 *             .namePrefix("prod_sp_")
 *             .signatureValidityPeriod(SigningProfileSignatureValidityPeriodArgs.builder()
 *                 .value(5)
 *                 .type("YEARS")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2")
 *             ))
 *             .build());
 *         var spPermission1 = new SigningProfilePermission("spPermission1", SigningProfilePermissionArgs.builder()
 *             .profileName(prodSp.name())
 *             .action("signer:StartSigningJob")
 *             .principal(var_.aws_account())
 *             .build());
 *         var spPermission2 = new SigningProfilePermission("spPermission2", SigningProfilePermissionArgs.builder()
 *             .profileName(prodSp.name())
 *             .action("signer:GetSigningProfile")
 *             .principal(var_.aws_team_role_arn())
 *             .statementId("ProdAccountStartSigningJob_StatementId")
 *             .build());
 *         var spPermission3 = new SigningProfilePermission("spPermission3", SigningProfilePermissionArgs.builder()
 *             .profileName(prodSp.name())
 *             .action("signer:RevokeSignature")
 *             .principal("123456789012")
 *             .profileVersion(prodSp.version())
 *             .statementIdPrefix("version-permission-")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Signer signing profile permission statements using profile_name/statement_id. For example:
 * ```sh
 *  $ pulumi import aws:signer/signingProfilePermission:SigningProfilePermission test_signer_signing_profile_permission prod_profile_DdW3Mk1foYL88fajut4mTVFGpuwfd4ACO6ANL0D1uIj7lrn8adK/ProdAccountStartSigningJobStatementId
 * ```
 *
 */
public class SigningProfilePermission internal constructor(
    override val javaResource: com.pulumi.aws.signer.SigningProfilePermission,
) : KotlinCustomResource(javaResource, SigningProfilePermissionMapper) {
    /**
     * An AWS Signer action permitted as part of cross-account permissions. Valid values: `signer:StartSigningJob`, `signer:GetSigningProfile`, `signer:RevokeSignature`, or `signer:SignPayload`.
     */
    public val action: Output<String>
        get() = javaResource.action().applyValue({ args0 -> args0 })

    /**
     * The AWS principal to be granted a cross-account permission.
     */
    public val principal: Output<String>
        get() = javaResource.principal().applyValue({ args0 -> args0 })

    /**
     * Name of the signing profile to add the cross-account permissions.
     */
    public val profileName: Output<String>
        get() = javaResource.profileName().applyValue({ args0 -> args0 })

    /**
     * The signing profile version that a permission applies to.
     */
    public val profileVersion: Output<String>
        get() = javaResource.profileVersion().applyValue({ args0 -> args0 })

    /**
     * A unique statement identifier. By default generated by the provider.
     */
    public val statementId: Output<String>
        get() = javaResource.statementId().applyValue({ args0 -> args0 })

    /**
     * A statement identifier prefix. The provider will generate a unique suffix. Conflicts with `statement_id`.
     */
    public val statementIdPrefix: Output<String>
        get() = javaResource.statementIdPrefix().applyValue({ args0 -> args0 })
}

public object SigningProfilePermissionMapper : ResourceMapper<SigningProfilePermission> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.signer.SigningProfilePermission::class == javaResource::class

    override fun map(javaResource: Resource): SigningProfilePermission =
        SigningProfilePermission(javaResource as com.pulumi.aws.signer.SigningProfilePermission)
}

/**
 * @see [SigningProfilePermission].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SigningProfilePermission].
 */
public suspend fun signingProfilePermission(
    name: String,
    block: suspend SigningProfilePermissionResourceBuilder.() -> Unit,
): SigningProfilePermission {
    val builder = SigningProfilePermissionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SigningProfilePermission].
 * @param name The _unique_ name of the resulting resource.
 */
public fun signingProfilePermission(name: String): SigningProfilePermission {
    val builder = SigningProfilePermissionResourceBuilder()
    builder.name(name)
    return builder.build()
}
