@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.signer.kotlin

import com.pulumi.aws.signer.SigningProfilePermissionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Creates a Signer Signing Profile Permission. That is, a cross-account permission for a signing profile.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.signer.SigningProfile;
 * import com.pulumi.aws.signer.SigningProfileArgs;
 * import com.pulumi.aws.signer.inputs.SigningProfileSignatureValidityPeriodArgs;
 * import com.pulumi.aws.signer.SigningProfilePermission;
 * import com.pulumi.aws.signer.SigningProfilePermissionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var prodSp = new SigningProfile("prodSp", SigningProfileArgs.builder()
 *             .platformId("AWSLambda-SHA384-ECDSA")
 *             .namePrefix("prod_sp_")
 *             .signatureValidityPeriod(SigningProfileSignatureValidityPeriodArgs.builder()
 *                 .value(5)
 *                 .type("YEARS")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2")
 *             ))
 *             .build());
 *         var spPermission1 = new SigningProfilePermission("spPermission1", SigningProfilePermissionArgs.builder()
 *             .profileName(prodSp.name())
 *             .action("signer:StartSigningJob")
 *             .principal(var_.aws_account())
 *             .build());
 *         var spPermission2 = new SigningProfilePermission("spPermission2", SigningProfilePermissionArgs.builder()
 *             .profileName(prodSp.name())
 *             .action("signer:GetSigningProfile")
 *             .principal(var_.aws_team_role_arn())
 *             .statementId("ProdAccountStartSigningJob_StatementId")
 *             .build());
 *         var spPermission3 = new SigningProfilePermission("spPermission3", SigningProfilePermissionArgs.builder()
 *             .profileName(prodSp.name())
 *             .action("signer:RevokeSignature")
 *             .principal("123456789012")
 *             .profileVersion(prodSp.version())
 *             .statementIdPrefix("version-permission-")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Signer signing profile permission statements using profile_name/statement_id. For example:
 * ```sh
 *  $ pulumi import aws:signer/signingProfilePermission:SigningProfilePermission test_signer_signing_profile_permission prod_profile_DdW3Mk1foYL88fajut4mTVFGpuwfd4ACO6ANL0D1uIj7lrn8adK/ProdAccountStartSigningJobStatementId
 * ```
 * @property action An AWS Signer action permitted as part of cross-account permissions. Valid values: `signer:StartSigningJob`, `signer:GetSigningProfile`, `signer:RevokeSignature`, or `signer:SignPayload`.
 * @property principal The AWS principal to be granted a cross-account permission.
 * @property profileName Name of the signing profile to add the cross-account permissions.
 * @property profileVersion The signing profile version that a permission applies to.
 * @property statementId A unique statement identifier. By default generated by the provider.
 * @property statementIdPrefix A statement identifier prefix. The provider will generate a unique suffix. Conflicts with `statement_id`.
 */
public data class SigningProfilePermissionArgs(
    public val action: Output<String>? = null,
    public val principal: Output<String>? = null,
    public val profileName: Output<String>? = null,
    public val profileVersion: Output<String>? = null,
    public val statementId: Output<String>? = null,
    public val statementIdPrefix: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.signer.SigningProfilePermissionArgs> {
    override fun toJava(): com.pulumi.aws.signer.SigningProfilePermissionArgs =
        com.pulumi.aws.signer.SigningProfilePermissionArgs.builder()
            .action(action?.applyValue({ args0 -> args0 }))
            .principal(principal?.applyValue({ args0 -> args0 }))
            .profileName(profileName?.applyValue({ args0 -> args0 }))
            .profileVersion(profileVersion?.applyValue({ args0 -> args0 }))
            .statementId(statementId?.applyValue({ args0 -> args0 }))
            .statementIdPrefix(statementIdPrefix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SigningProfilePermissionArgs].
 */
@PulumiTagMarker
public class SigningProfilePermissionArgsBuilder internal constructor() {
    private var action: Output<String>? = null

    private var principal: Output<String>? = null

    private var profileName: Output<String>? = null

    private var profileVersion: Output<String>? = null

    private var statementId: Output<String>? = null

    private var statementIdPrefix: Output<String>? = null

    /**
     * @param value An AWS Signer action permitted as part of cross-account permissions. Valid values: `signer:StartSigningJob`, `signer:GetSigningProfile`, `signer:RevokeSignature`, or `signer:SignPayload`.
     */
    @JvmName("xojpcgeacknbfrnx")
    public suspend fun action(`value`: Output<String>) {
        this.action = value
    }

    /**
     * @param value The AWS principal to be granted a cross-account permission.
     */
    @JvmName("txhaxxfahhgoexyq")
    public suspend fun principal(`value`: Output<String>) {
        this.principal = value
    }

    /**
     * @param value Name of the signing profile to add the cross-account permissions.
     */
    @JvmName("nsthltpmtoapteva")
    public suspend fun profileName(`value`: Output<String>) {
        this.profileName = value
    }

    /**
     * @param value The signing profile version that a permission applies to.
     */
    @JvmName("lxsltepbmscqapnu")
    public suspend fun profileVersion(`value`: Output<String>) {
        this.profileVersion = value
    }

    /**
     * @param value A unique statement identifier. By default generated by the provider.
     */
    @JvmName("qywaojhraqrqjvvk")
    public suspend fun statementId(`value`: Output<String>) {
        this.statementId = value
    }

    /**
     * @param value A statement identifier prefix. The provider will generate a unique suffix. Conflicts with `statement_id`.
     */
    @JvmName("luwsngicretprskt")
    public suspend fun statementIdPrefix(`value`: Output<String>) {
        this.statementIdPrefix = value
    }

    /**
     * @param value An AWS Signer action permitted as part of cross-account permissions. Valid values: `signer:StartSigningJob`, `signer:GetSigningProfile`, `signer:RevokeSignature`, or `signer:SignPayload`.
     */
    @JvmName("jqnajqxoxohjnbab")
    public suspend fun action(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value The AWS principal to be granted a cross-account permission.
     */
    @JvmName("efdymcokvmdlytgp")
    public suspend fun principal(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principal = mapped
    }

    /**
     * @param value Name of the signing profile to add the cross-account permissions.
     */
    @JvmName("voqvvqdnvityqtcc")
    public suspend fun profileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.profileName = mapped
    }

    /**
     * @param value The signing profile version that a permission applies to.
     */
    @JvmName("hcjfeqxmaeqsryys")
    public suspend fun profileVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.profileVersion = mapped
    }

    /**
     * @param value A unique statement identifier. By default generated by the provider.
     */
    @JvmName("kiyfvxuawjmpidee")
    public suspend fun statementId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statementId = mapped
    }

    /**
     * @param value A statement identifier prefix. The provider will generate a unique suffix. Conflicts with `statement_id`.
     */
    @JvmName("ofekpxwmrrvuqgod")
    public suspend fun statementIdPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statementIdPrefix = mapped
    }

    internal fun build(): SigningProfilePermissionArgs = SigningProfilePermissionArgs(
        action = action,
        principal = principal,
        profileName = profileName,
        profileVersion = profileVersion,
        statementId = statementId,
        statementIdPrefix = statementIdPrefix,
    )
}
