@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.signer.kotlin.inputs

import com.pulumi.aws.signer.inputs.GetSigningProfilePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSigningProfile.
 * @property name Name of the target signing profile.
 * @property tags List of tags associated with the signing profile.
 */
public data class GetSigningProfilePlainArgs(
    public val name: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.signer.inputs.GetSigningProfilePlainArgs> {
    override fun toJava(): com.pulumi.aws.signer.inputs.GetSigningProfilePlainArgs =
        com.pulumi.aws.signer.inputs.GetSigningProfilePlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetSigningProfilePlainArgs].
 */
@PulumiTagMarker
public class GetSigningProfilePlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Name of the target signing profile.
     */
    @JvmName("qshbetsnolilhdoy")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value List of tags associated with the signing profile.
     */
    @JvmName("pffrqjdnfshpjtgc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values List of tags associated with the signing profile.
     */
    @JvmName("vxshcweiejaueevw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetSigningProfilePlainArgs = GetSigningProfilePlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        tags = tags,
    )
}
