@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.signer.kotlin.inputs

import com.pulumi.aws.signer.inputs.SigningJobDestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property s3 A configuration block describing the S3 Destination object: See S3 Destination below for details.
 */
public data class SigningJobDestinationArgs(
    public val s3: Output<SigningJobDestinationS3Args>,
) : ConvertibleToJava<com.pulumi.aws.signer.inputs.SigningJobDestinationArgs> {
    override fun toJava(): com.pulumi.aws.signer.inputs.SigningJobDestinationArgs =
        com.pulumi.aws.signer.inputs.SigningJobDestinationArgs.builder()
            .s3(s3.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [SigningJobDestinationArgs].
 */
@PulumiTagMarker
public class SigningJobDestinationArgsBuilder internal constructor() {
    private var s3: Output<SigningJobDestinationS3Args>? = null

    /**
     * @param value A configuration block describing the S3 Destination object: See S3 Destination below for details.
     */
    @JvmName("wlnpwxwjbmipcuwx")
    public suspend fun s3(`value`: Output<SigningJobDestinationS3Args>) {
        this.s3 = value
    }

    /**
     * @param value A configuration block describing the S3 Destination object: See S3 Destination below for details.
     */
    @JvmName("kjxvljtfsprasqnj")
    public suspend fun s3(`value`: SigningJobDestinationS3Args) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3 = mapped
    }

    /**
     * @param argument A configuration block describing the S3 Destination object: See S3 Destination below for details.
     */
    @JvmName("dmhswyfguvadkinn")
    public suspend fun s3(argument: suspend SigningJobDestinationS3ArgsBuilder.() -> Unit) {
        val toBeMapped = SigningJobDestinationS3ArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.s3 = mapped
    }

    internal fun build(): SigningJobDestinationArgs = SigningJobDestinationArgs(
        s3 = s3 ?: throw PulumiNullFieldException("s3"),
    )
}
