@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.signer.kotlin.inputs

import com.pulumi.aws.signer.inputs.SigningJobSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property s3 A configuration block describing the S3 Source object: See S3 Source below for details.
 */
public data class SigningJobSourceArgs(
    public val s3: Output<SigningJobSourceS3Args>,
) : ConvertibleToJava<com.pulumi.aws.signer.inputs.SigningJobSourceArgs> {
    override fun toJava(): com.pulumi.aws.signer.inputs.SigningJobSourceArgs =
        com.pulumi.aws.signer.inputs.SigningJobSourceArgs.builder()
            .s3(s3.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [SigningJobSourceArgs].
 */
@PulumiTagMarker
public class SigningJobSourceArgsBuilder internal constructor() {
    private var s3: Output<SigningJobSourceS3Args>? = null

    /**
     * @param value A configuration block describing the S3 Source object: See S3 Source below for details.
     */
    @JvmName("obyihjjslibqfnxq")
    public suspend fun s3(`value`: Output<SigningJobSourceS3Args>) {
        this.s3 = value
    }

    /**
     * @param value A configuration block describing the S3 Source object: See S3 Source below for details.
     */
    @JvmName("uuqjovrpucdvyyrk")
    public suspend fun s3(`value`: SigningJobSourceS3Args) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3 = mapped
    }

    /**
     * @param argument A configuration block describing the S3 Source object: See S3 Source below for details.
     */
    @JvmName("mgyjunrcpnlymmrb")
    public suspend fun s3(argument: suspend SigningJobSourceS3ArgsBuilder.() -> Unit) {
        val toBeMapped = SigningJobSourceS3ArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.s3 = mapped
    }

    internal fun build(): SigningJobSourceArgs = SigningJobSourceArgs(
        s3 = s3 ?: throw PulumiNullFieldException("s3"),
    )
}
