@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.signer.kotlin.inputs

import com.pulumi.aws.signer.inputs.SigningProfileSigningMaterialArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property certificateArn
 */
public data class SigningProfileSigningMaterialArgs(
    public val certificateArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.signer.inputs.SigningProfileSigningMaterialArgs> {
    override fun toJava(): com.pulumi.aws.signer.inputs.SigningProfileSigningMaterialArgs =
        com.pulumi.aws.signer.inputs.SigningProfileSigningMaterialArgs.builder()
            .certificateArn(certificateArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SigningProfileSigningMaterialArgs].
 */
@PulumiTagMarker
public class SigningProfileSigningMaterialArgsBuilder internal constructor() {
    private var certificateArn: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("qrwwmjiusquuflus")
    public suspend fun certificateArn(`value`: Output<String>) {
        this.certificateArn = value
    }

    /**
     * @param value
     */
    @JvmName("yrnsshtmmfdbqmao")
    public suspend fun certificateArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificateArn = mapped
    }

    internal fun build(): SigningProfileSigningMaterialArgs = SigningProfileSigningMaterialArgs(
        certificateArn = certificateArn ?: throw PulumiNullFieldException("certificateArn"),
    )
}
