@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.signer.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getSigningJob.
 * @property completedAt Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the signing job was completed.
 * @property createdAt Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the signing job was created.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property jobId
 * @property jobInvoker IAM entity that initiated the signing job.
 * @property jobOwner AWS account ID of the job owner.
 * @property platformDisplayName A human-readable name for the signing platform associated with the signing job.
 * @property platformId Platform to which your signed code image will be distributed.
 * @property profileName Name of the profile that initiated the signing operation.
 * @property profileVersion Version of the signing profile used to initiate the signing job.
 * @property requestedBy IAM principal that requested the signing job.
 * @property revocationRecords Revocation record if the signature generated by the signing job has been revoked. Contains a timestamp and the ID of the IAM entity that revoked the signature.
 * @property signatureExpiresAt The time when the signature of a signing job expires.
 * @property signedObjects Name of the S3 bucket where the signed code image is saved by code signing.
 * @property sources Object that contains the name of your S3 bucket or your raw code.
 * @property status Status of the signing job.
 * @property statusReason String value that contains the status reason.
 */
public data class GetSigningJobResult(
    public val completedAt: String,
    public val createdAt: String,
    public val id: String,
    public val jobId: String,
    public val jobInvoker: String,
    public val jobOwner: String,
    public val platformDisplayName: String,
    public val platformId: String,
    public val profileName: String,
    public val profileVersion: String,
    public val requestedBy: String,
    public val revocationRecords: List<GetSigningJobRevocationRecord>,
    public val signatureExpiresAt: String,
    public val signedObjects: List<GetSigningJobSignedObject>,
    public val sources: List<GetSigningJobSource>,
    public val status: String,
    public val statusReason: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.signer.outputs.GetSigningJobResult):
            GetSigningJobResult = GetSigningJobResult(
            completedAt = javaType.completedAt(),
            createdAt = javaType.createdAt(),
            id = javaType.id(),
            jobId = javaType.jobId(),
            jobInvoker = javaType.jobInvoker(),
            jobOwner = javaType.jobOwner(),
            platformDisplayName = javaType.platformDisplayName(),
            platformId = javaType.platformId(),
            profileName = javaType.profileName(),
            profileVersion = javaType.profileVersion(),
            requestedBy = javaType.requestedBy(),
            revocationRecords = javaType.revocationRecords().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.signer.kotlin.outputs.GetSigningJobRevocationRecord.Companion.toKotlin(args0)
                })
            }),
            signatureExpiresAt = javaType.signatureExpiresAt(),
            signedObjects = javaType.signedObjects().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.signer.kotlin.outputs.GetSigningJobSignedObject.Companion.toKotlin(args0)
                })
            }),
            sources = javaType.sources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.signer.kotlin.outputs.GetSigningJobSource.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status(),
            statusReason = javaType.statusReason(),
        )
    }
}
