@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.simpledb.kotlin

import com.pulumi.aws.simpledb.DomainArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a SimpleDB domain resource
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.simpledb.Domain;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var users = new Domain("users");
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SimpleDB Domains using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:simpledb/domain:Domain users users
 * ```
 * @property name The name of the SimpleDB domain
 */
public data class DomainArgs(
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.simpledb.DomainArgs> {
    override fun toJava(): com.pulumi.aws.simpledb.DomainArgs =
        com.pulumi.aws.simpledb.DomainArgs.builder()
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainArgs].
 */
@PulumiTagMarker
public class DomainArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    /**
     * @param value The name of the SimpleDB domain
     */
    @JvmName("ksqacmhqlvqmshub")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the SimpleDB domain
     */
    @JvmName("iljiflhsamsumlua")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): DomainArgs = DomainArgs(
        name = name,
    )
}
