@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sns.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DataProtectionPolicy].
 */
@PulumiTagMarker
public class DataProtectionPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DataProtectionPolicyArgs = DataProtectionPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DataProtectionPolicyArgsBuilder.() -> Unit) {
        val builder = DataProtectionPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DataProtectionPolicy {
        val builtJavaResource = com.pulumi.aws.sns.DataProtectionPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DataProtectionPolicy(builtJavaResource)
    }
}

/**
 * Provides an SNS data protection topic policy resource
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.sns.DataProtectionPolicy;
 * import com.pulumi.aws.sns.DataProtectionPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleTopic = new Topic("exampleTopic");
 *         var exampleDataProtectionPolicy = new DataProtectionPolicy("exampleDataProtectionPolicy", DataProtectionPolicyArgs.builder()
 *             .arn(exampleTopic.arn())
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Description", "Example data protection policy"),
 *                     jsonProperty("Name", "__example_data_protection_policy"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("DataDirection", "Inbound"),
 *                         jsonProperty("DataIdentifier", jsonArray("arn:aws:dataprotection::aws:data-identifier/EmailAddress")),
 *                         jsonProperty("Operation", jsonObject(
 *                             jsonProperty("Deny", jsonObject(
 *                             ))
 *                         )),
 *                         jsonProperty("Principal", jsonArray("*")),
 *                         jsonProperty("Sid", "__deny_statement_11ba9d96")
 *                     ))),
 *                     jsonProperty("Version", "2021-06-01")
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SNS Data Protection Topic Policy using the topic ARN. For example:
 * ```sh
 *  $ pulumi import aws:sns/dataProtectionPolicy:DataProtectionPolicy example arn:aws:sns:us-west-2:0123456789012:example
 * ```
 *
 */
public class DataProtectionPolicy internal constructor(
    override val javaResource: com.pulumi.aws.sns.DataProtectionPolicy,
) : KotlinCustomResource(javaResource, DataProtectionPolicyMapper) {
    /**
     * The ARN of the SNS topic
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The fully-formed AWS policy as JSON. For more information about building AWS IAM policy documents with this provider, see the AWS IAM Policy Document Guide.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })
}

public object DataProtectionPolicyMapper : ResourceMapper<DataProtectionPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sns.DataProtectionPolicy::class == javaResource::class

    override fun map(javaResource: Resource): DataProtectionPolicy = DataProtectionPolicy(
        javaResource
            as com.pulumi.aws.sns.DataProtectionPolicy,
    )
}

/**
 * @see [DataProtectionPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DataProtectionPolicy].
 */
public suspend fun dataProtectionPolicy(
    name: String,
    block: suspend DataProtectionPolicyResourceBuilder.() -> Unit,
): DataProtectionPolicy {
    val builder = DataProtectionPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DataProtectionPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dataProtectionPolicy(name: String): DataProtectionPolicy {
    val builder = DataProtectionPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
