@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sns.kotlin

import com.pulumi.aws.sns.DataProtectionPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an SNS data protection topic policy resource
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.sns.DataProtectionPolicy;
 * import com.pulumi.aws.sns.DataProtectionPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleTopic = new Topic("exampleTopic");
 *         var exampleDataProtectionPolicy = new DataProtectionPolicy("exampleDataProtectionPolicy", DataProtectionPolicyArgs.builder()
 *             .arn(exampleTopic.arn())
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Description", "Example data protection policy"),
 *                     jsonProperty("Name", "__example_data_protection_policy"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("DataDirection", "Inbound"),
 *                         jsonProperty("DataIdentifier", jsonArray("arn:aws:dataprotection::aws:data-identifier/EmailAddress")),
 *                         jsonProperty("Operation", jsonObject(
 *                             jsonProperty("Deny", jsonObject(
 *                             ))
 *                         )),
 *                         jsonProperty("Principal", jsonArray("*")),
 *                         jsonProperty("Sid", "__deny_statement_11ba9d96")
 *                     ))),
 *                     jsonProperty("Version", "2021-06-01")
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SNS Data Protection Topic Policy using the topic ARN. For example:
 * ```sh
 *  $ pulumi import aws:sns/dataProtectionPolicy:DataProtectionPolicy example arn:aws:sns:us-west-2:0123456789012:example
 * ```
 * @property arn The ARN of the SNS topic
 * @property policy The fully-formed AWS policy as JSON. For more information about building AWS IAM policy documents with this provider, see the AWS IAM Policy Document Guide.
 */
public data class DataProtectionPolicyArgs(
    public val arn: Output<String>? = null,
    public val policy: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sns.DataProtectionPolicyArgs> {
    override fun toJava(): com.pulumi.aws.sns.DataProtectionPolicyArgs =
        com.pulumi.aws.sns.DataProtectionPolicyArgs.builder()
            .arn(arn?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataProtectionPolicyArgs].
 */
@PulumiTagMarker
public class DataProtectionPolicyArgsBuilder internal constructor() {
    private var arn: Output<String>? = null

    private var policy: Output<String>? = null

    /**
     * @param value The ARN of the SNS topic
     */
    @JvmName("kllrqatobkenpbdn")
    public suspend fun arn(`value`: Output<String>) {
        this.arn = value
    }

    /**
     * @param value The fully-formed AWS policy as JSON. For more information about building AWS IAM policy documents with this provider, see the AWS IAM Policy Document Guide.
     */
    @JvmName("wejvljcpksbwgiou")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value The ARN of the SNS topic
     */
    @JvmName("rwiahaabdadagdos")
    public suspend fun arn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arn = mapped
    }

    /**
     * @param value The fully-formed AWS policy as JSON. For more information about building AWS IAM policy documents with this provider, see the AWS IAM Policy Document Guide.
     */
    @JvmName("yixlcvqgwooakyfc")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    internal fun build(): DataProtectionPolicyArgs = DataProtectionPolicyArgs(
        arn = arn,
        policy = policy,
    )
}
