@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sns.kotlin

import com.pulumi.aws.sns.PlatformApplicationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an SNS platform application resource
 * ## Example Usage
 * ### Apple Push Notification Service (APNS) using certificate-based authentication
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sns.PlatformApplication;
 * import com.pulumi.aws.sns.PlatformApplicationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apnsApplication = new PlatformApplication("apnsApplication", PlatformApplicationArgs.builder()
 *             .platform("APNS")
 *             .platformCredential("<APNS PRIVATE KEY>")
 *             .platformPrincipal("<APNS CERTIFICATE>")
 *             .build());
 *     }
 * }
 * ```
 * ### Apple Push Notification Service (APNS) using token-based authentication
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sns.PlatformApplication;
 * import com.pulumi.aws.sns.PlatformApplicationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apnsApplication = new PlatformApplication("apnsApplication", PlatformApplicationArgs.builder()
 *             .applePlatformBundleId("<APPLE BUNDLE ID>")
 *             .applePlatformTeamId("<APPLE TEAM ID>")
 *             .platform("APNS")
 *             .platformCredential("<APNS SIGNING KEY>")
 *             .platformPrincipal("<APNS SIGNING KEY ID>")
 *             .build());
 *     }
 * }
 * ```
 * ### Google Cloud Messaging (GCM)
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sns.PlatformApplication;
 * import com.pulumi.aws.sns.PlatformApplicationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var gcmApplication = new PlatformApplication("gcmApplication", PlatformApplicationArgs.builder()
 *             .platform("GCM")
 *             .platformCredential("<GCM API KEY>")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SNS platform applications using the ARN. For example:
 * ```sh
 *  $ pulumi import aws:sns/platformApplication:PlatformApplication gcm_application arn:aws:sns:us-west-2:0123456789012:app/GCM/gcm_application
 * ```
 * @property applePlatformBundleId The bundle identifier that's assigned to your iOS app. May only include alphanumeric characters, hyphens (-), and periods (.).
 * @property applePlatformTeamId The identifier that's assigned to your Apple developer account team. Must be 10 alphanumeric characters.
 * @property eventDeliveryFailureTopicArn The ARN of the SNS Topic triggered when a delivery to any of the platform endpoints associated with your platform application encounters a permanent failure.
 * @property eventEndpointCreatedTopicArn The ARN of the SNS Topic triggered when a new platform endpoint is added to your platform application.
 * @property eventEndpointDeletedTopicArn The ARN of the SNS Topic triggered when an existing platform endpoint is deleted from your platform application.
 * @property eventEndpointUpdatedTopicArn The ARN of the SNS Topic triggered when an existing platform endpoint is changed from your platform application.
 * @property failureFeedbackRoleArn The IAM role ARN permitted to receive failure feedback for this application and give SNS write access to use CloudWatch logs on your behalf.
 * @property name The friendly name for the SNS platform application
 * @property platform The platform that the app is registered with. See [Platform](http://docs.aws.amazon.com/sns/latest/dg/mobile-push-send-register.html) for supported platforms.
 * @property platformCredential Application Platform credential. See [Credential](http://docs.aws.amazon.com/sns/latest/dg/mobile-push-send-register.html) for type of credential required for platform. The value of this attribute when stored into the state is only a hash of the real value, so therefore it is not practical to use this as an attribute for other resources.
 * @property platformPrincipal Application Platform principal. See [Principal](http://docs.aws.amazon.com/sns/latest/api/API_CreatePlatformApplication.html) for type of principal required for platform. The value of this attribute when stored into the state is only a hash of the real value, so therefore it is not practical to use this as an attribute for other resources.
 * @property successFeedbackRoleArn The IAM role ARN permitted to receive success feedback for this application and give SNS write access to use CloudWatch logs on your behalf.
 * @property successFeedbackSampleRate The sample rate percentage (0-100) of successfully delivered messages.
 * The following attributes are needed only when using APNS token credentials:
 */
public data class PlatformApplicationArgs(
    public val applePlatformBundleId: Output<String>? = null,
    public val applePlatformTeamId: Output<String>? = null,
    public val eventDeliveryFailureTopicArn: Output<String>? = null,
    public val eventEndpointCreatedTopicArn: Output<String>? = null,
    public val eventEndpointDeletedTopicArn: Output<String>? = null,
    public val eventEndpointUpdatedTopicArn: Output<String>? = null,
    public val failureFeedbackRoleArn: Output<String>? = null,
    public val name: Output<String>? = null,
    public val platform: Output<String>? = null,
    public val platformCredential: Output<String>? = null,
    public val platformPrincipal: Output<String>? = null,
    public val successFeedbackRoleArn: Output<String>? = null,
    public val successFeedbackSampleRate: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sns.PlatformApplicationArgs> {
    override fun toJava(): com.pulumi.aws.sns.PlatformApplicationArgs =
        com.pulumi.aws.sns.PlatformApplicationArgs.builder()
            .applePlatformBundleId(applePlatformBundleId?.applyValue({ args0 -> args0 }))
            .applePlatformTeamId(applePlatformTeamId?.applyValue({ args0 -> args0 }))
            .eventDeliveryFailureTopicArn(eventDeliveryFailureTopicArn?.applyValue({ args0 -> args0 }))
            .eventEndpointCreatedTopicArn(eventEndpointCreatedTopicArn?.applyValue({ args0 -> args0 }))
            .eventEndpointDeletedTopicArn(eventEndpointDeletedTopicArn?.applyValue({ args0 -> args0 }))
            .eventEndpointUpdatedTopicArn(eventEndpointUpdatedTopicArn?.applyValue({ args0 -> args0 }))
            .failureFeedbackRoleArn(failureFeedbackRoleArn?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .platform(platform?.applyValue({ args0 -> args0 }))
            .platformCredential(platformCredential?.applyValue({ args0 -> args0 }))
            .platformPrincipal(platformPrincipal?.applyValue({ args0 -> args0 }))
            .successFeedbackRoleArn(successFeedbackRoleArn?.applyValue({ args0 -> args0 }))
            .successFeedbackSampleRate(successFeedbackSampleRate?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PlatformApplicationArgs].
 */
@PulumiTagMarker
public class PlatformApplicationArgsBuilder internal constructor() {
    private var applePlatformBundleId: Output<String>? = null

    private var applePlatformTeamId: Output<String>? = null

    private var eventDeliveryFailureTopicArn: Output<String>? = null

    private var eventEndpointCreatedTopicArn: Output<String>? = null

    private var eventEndpointDeletedTopicArn: Output<String>? = null

    private var eventEndpointUpdatedTopicArn: Output<String>? = null

    private var failureFeedbackRoleArn: Output<String>? = null

    private var name: Output<String>? = null

    private var platform: Output<String>? = null

    private var platformCredential: Output<String>? = null

    private var platformPrincipal: Output<String>? = null

    private var successFeedbackRoleArn: Output<String>? = null

    private var successFeedbackSampleRate: Output<String>? = null

    /**
     * @param value The bundle identifier that's assigned to your iOS app. May only include alphanumeric characters, hyphens (-), and periods (.).
     */
    @JvmName("nwbonwvmowvdesaf")
    public suspend fun applePlatformBundleId(`value`: Output<String>) {
        this.applePlatformBundleId = value
    }

    /**
     * @param value The identifier that's assigned to your Apple developer account team. Must be 10 alphanumeric characters.
     */
    @JvmName("jabdodgcblnekjrp")
    public suspend fun applePlatformTeamId(`value`: Output<String>) {
        this.applePlatformTeamId = value
    }

    /**
     * @param value The ARN of the SNS Topic triggered when a delivery to any of the platform endpoints associated with your platform application encounters a permanent failure.
     */
    @JvmName("ivuohoqqhnoiujjg")
    public suspend fun eventDeliveryFailureTopicArn(`value`: Output<String>) {
        this.eventDeliveryFailureTopicArn = value
    }

    /**
     * @param value The ARN of the SNS Topic triggered when a new platform endpoint is added to your platform application.
     */
    @JvmName("agplhyuddfggibvg")
    public suspend fun eventEndpointCreatedTopicArn(`value`: Output<String>) {
        this.eventEndpointCreatedTopicArn = value
    }

    /**
     * @param value The ARN of the SNS Topic triggered when an existing platform endpoint is deleted from your platform application.
     */
    @JvmName("dgljjjbovnqjwwip")
    public suspend fun eventEndpointDeletedTopicArn(`value`: Output<String>) {
        this.eventEndpointDeletedTopicArn = value
    }

    /**
     * @param value The ARN of the SNS Topic triggered when an existing platform endpoint is changed from your platform application.
     */
    @JvmName("rcvyptrvgxvghjqh")
    public suspend fun eventEndpointUpdatedTopicArn(`value`: Output<String>) {
        this.eventEndpointUpdatedTopicArn = value
    }

    /**
     * @param value The IAM role ARN permitted to receive failure feedback for this application and give SNS write access to use CloudWatch logs on your behalf.
     */
    @JvmName("keyrawahnvxklxdn")
    public suspend fun failureFeedbackRoleArn(`value`: Output<String>) {
        this.failureFeedbackRoleArn = value
    }

    /**
     * @param value The friendly name for the SNS platform application
     */
    @JvmName("etuswrqrxqfocnyq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The platform that the app is registered with. See [Platform](http://docs.aws.amazon.com/sns/latest/dg/mobile-push-send-register.html) for supported platforms.
     */
    @JvmName("ipusdnlamhmdxgai")
    public suspend fun platform(`value`: Output<String>) {
        this.platform = value
    }

    /**
     * @param value Application Platform credential. See [Credential](http://docs.aws.amazon.com/sns/latest/dg/mobile-push-send-register.html) for type of credential required for platform. The value of this attribute when stored into the state is only a hash of the real value, so therefore it is not practical to use this as an attribute for other resources.
     */
    @JvmName("vvcgrwqwbtnatnkv")
    public suspend fun platformCredential(`value`: Output<String>) {
        this.platformCredential = value
    }

    /**
     * @param value Application Platform principal. See [Principal](http://docs.aws.amazon.com/sns/latest/api/API_CreatePlatformApplication.html) for type of principal required for platform. The value of this attribute when stored into the state is only a hash of the real value, so therefore it is not practical to use this as an attribute for other resources.
     */
    @JvmName("fdwbebndwnlfxxee")
    public suspend fun platformPrincipal(`value`: Output<String>) {
        this.platformPrincipal = value
    }

    /**
     * @param value The IAM role ARN permitted to receive success feedback for this application and give SNS write access to use CloudWatch logs on your behalf.
     */
    @JvmName("yaonnfcjomfgodrj")
    public suspend fun successFeedbackRoleArn(`value`: Output<String>) {
        this.successFeedbackRoleArn = value
    }

    /**
     * @param value The sample rate percentage (0-100) of successfully delivered messages.
     * The following attributes are needed only when using APNS token credentials:
     */
    @JvmName("xuqikrwenighqbml")
    public suspend fun successFeedbackSampleRate(`value`: Output<String>) {
        this.successFeedbackSampleRate = value
    }

    /**
     * @param value The bundle identifier that's assigned to your iOS app. May only include alphanumeric characters, hyphens (-), and periods (.).
     */
    @JvmName("mmduencidnorfckf")
    public suspend fun applePlatformBundleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applePlatformBundleId = mapped
    }

    /**
     * @param value The identifier that's assigned to your Apple developer account team. Must be 10 alphanumeric characters.
     */
    @JvmName("sbjljvrwxkehfmcf")
    public suspend fun applePlatformTeamId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applePlatformTeamId = mapped
    }

    /**
     * @param value The ARN of the SNS Topic triggered when a delivery to any of the platform endpoints associated with your platform application encounters a permanent failure.
     */
    @JvmName("ivggmtlhjyphaakd")
    public suspend fun eventDeliveryFailureTopicArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventDeliveryFailureTopicArn = mapped
    }

    /**
     * @param value The ARN of the SNS Topic triggered when a new platform endpoint is added to your platform application.
     */
    @JvmName("tmawkgwlcodhskfo")
    public suspend fun eventEndpointCreatedTopicArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventEndpointCreatedTopicArn = mapped
    }

    /**
     * @param value The ARN of the SNS Topic triggered when an existing platform endpoint is deleted from your platform application.
     */
    @JvmName("vaomomdixwouscfo")
    public suspend fun eventEndpointDeletedTopicArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventEndpointDeletedTopicArn = mapped
    }

    /**
     * @param value The ARN of the SNS Topic triggered when an existing platform endpoint is changed from your platform application.
     */
    @JvmName("hrwidmbeprivupnr")
    public suspend fun eventEndpointUpdatedTopicArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventEndpointUpdatedTopicArn = mapped
    }

    /**
     * @param value The IAM role ARN permitted to receive failure feedback for this application and give SNS write access to use CloudWatch logs on your behalf.
     */
    @JvmName("xpkflnerftsukbry")
    public suspend fun failureFeedbackRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failureFeedbackRoleArn = mapped
    }

    /**
     * @param value The friendly name for the SNS platform application
     */
    @JvmName("jfuetvxxgjmttpdb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The platform that the app is registered with. See [Platform](http://docs.aws.amazon.com/sns/latest/dg/mobile-push-send-register.html) for supported platforms.
     */
    @JvmName("pgcurwbnochsigjc")
    public suspend fun platform(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.platform = mapped
    }

    /**
     * @param value Application Platform credential. See [Credential](http://docs.aws.amazon.com/sns/latest/dg/mobile-push-send-register.html) for type of credential required for platform. The value of this attribute when stored into the state is only a hash of the real value, so therefore it is not practical to use this as an attribute for other resources.
     */
    @JvmName("kwaqxsybjrjonyml")
    public suspend fun platformCredential(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.platformCredential = mapped
    }

    /**
     * @param value Application Platform principal. See [Principal](http://docs.aws.amazon.com/sns/latest/api/API_CreatePlatformApplication.html) for type of principal required for platform. The value of this attribute when stored into the state is only a hash of the real value, so therefore it is not practical to use this as an attribute for other resources.
     */
    @JvmName("wrpuuohutcgtqyjw")
    public suspend fun platformPrincipal(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.platformPrincipal = mapped
    }

    /**
     * @param value The IAM role ARN permitted to receive success feedback for this application and give SNS write access to use CloudWatch logs on your behalf.
     */
    @JvmName("omqpafqgwvfkghnl")
    public suspend fun successFeedbackRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.successFeedbackRoleArn = mapped
    }

    /**
     * @param value The sample rate percentage (0-100) of successfully delivered messages.
     * The following attributes are needed only when using APNS token credentials:
     */
    @JvmName("ofcabnsjyfwumfox")
    public suspend fun successFeedbackSampleRate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.successFeedbackSampleRate = mapped
    }

    internal fun build(): PlatformApplicationArgs = PlatformApplicationArgs(
        applePlatformBundleId = applePlatformBundleId,
        applePlatformTeamId = applePlatformTeamId,
        eventDeliveryFailureTopicArn = eventDeliveryFailureTopicArn,
        eventEndpointCreatedTopicArn = eventEndpointCreatedTopicArn,
        eventEndpointDeletedTopicArn = eventEndpointDeletedTopicArn,
        eventEndpointUpdatedTopicArn = eventEndpointUpdatedTopicArn,
        failureFeedbackRoleArn = failureFeedbackRoleArn,
        name = name,
        platform = platform,
        platformCredential = platformCredential,
        platformPrincipal = platformPrincipal,
        successFeedbackRoleArn = successFeedbackRoleArn,
        successFeedbackSampleRate = successFeedbackSampleRate,
    )
}
