@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sns.kotlin

import com.pulumi.aws.sns.SmsPreferencesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a way to set SNS SMS preferences.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sns.SmsPreferences;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var updateSmsPrefs = new SmsPreferences("updateSmsPrefs");
 *     }
 * }
 * ```
 * @property defaultSenderId A string, such as your business brand, that is displayed as the sender on the receiving device.
 * @property defaultSmsType The type of SMS message that you will send by default. Possible values are: Promotional, Transactional
 * @property deliveryStatusIamRoleArn The ARN of the IAM role that allows Amazon SNS to write logs about SMS deliveries in CloudWatch Logs.
 * @property deliveryStatusSuccessSamplingRate The percentage of successful SMS deliveries for which Amazon SNS will write logs in CloudWatch Logs. The value must be between 0 and 100.
 * @property monthlySpendLimit The maximum amount in USD that you are willing to spend each month to send SMS messages.
 * @property usageReportS3Bucket The name of the Amazon S3 bucket to receive daily SMS usage reports from Amazon SNS.
 */
public data class SmsPreferencesArgs(
    public val defaultSenderId: Output<String>? = null,
    public val defaultSmsType: Output<String>? = null,
    public val deliveryStatusIamRoleArn: Output<String>? = null,
    public val deliveryStatusSuccessSamplingRate: Output<String>? = null,
    public val monthlySpendLimit: Output<Int>? = null,
    public val usageReportS3Bucket: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sns.SmsPreferencesArgs> {
    override fun toJava(): com.pulumi.aws.sns.SmsPreferencesArgs =
        com.pulumi.aws.sns.SmsPreferencesArgs.builder()
            .defaultSenderId(defaultSenderId?.applyValue({ args0 -> args0 }))
            .defaultSmsType(defaultSmsType?.applyValue({ args0 -> args0 }))
            .deliveryStatusIamRoleArn(deliveryStatusIamRoleArn?.applyValue({ args0 -> args0 }))
            .deliveryStatusSuccessSamplingRate(
                deliveryStatusSuccessSamplingRate?.applyValue({ args0 ->
                    args0
                }),
            )
            .monthlySpendLimit(monthlySpendLimit?.applyValue({ args0 -> args0 }))
            .usageReportS3Bucket(usageReportS3Bucket?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SmsPreferencesArgs].
 */
@PulumiTagMarker
public class SmsPreferencesArgsBuilder internal constructor() {
    private var defaultSenderId: Output<String>? = null

    private var defaultSmsType: Output<String>? = null

    private var deliveryStatusIamRoleArn: Output<String>? = null

    private var deliveryStatusSuccessSamplingRate: Output<String>? = null

    private var monthlySpendLimit: Output<Int>? = null

    private var usageReportS3Bucket: Output<String>? = null

    /**
     * @param value A string, such as your business brand, that is displayed as the sender on the receiving device.
     */
    @JvmName("rrsqqbimmyrywtyj")
    public suspend fun defaultSenderId(`value`: Output<String>) {
        this.defaultSenderId = value
    }

    /**
     * @param value The type of SMS message that you will send by default. Possible values are: Promotional, Transactional
     */
    @JvmName("eefhumbyjoqfvbis")
    public suspend fun defaultSmsType(`value`: Output<String>) {
        this.defaultSmsType = value
    }

    /**
     * @param value The ARN of the IAM role that allows Amazon SNS to write logs about SMS deliveries in CloudWatch Logs.
     */
    @JvmName("bgsurwrqedbjfhow")
    public suspend fun deliveryStatusIamRoleArn(`value`: Output<String>) {
        this.deliveryStatusIamRoleArn = value
    }

    /**
     * @param value The percentage of successful SMS deliveries for which Amazon SNS will write logs in CloudWatch Logs. The value must be between 0 and 100.
     */
    @JvmName("dylihyxhmayrrnqo")
    public suspend fun deliveryStatusSuccessSamplingRate(`value`: Output<String>) {
        this.deliveryStatusSuccessSamplingRate = value
    }

    /**
     * @param value The maximum amount in USD that you are willing to spend each month to send SMS messages.
     */
    @JvmName("pjjkiknkacwaxdxa")
    public suspend fun monthlySpendLimit(`value`: Output<Int>) {
        this.monthlySpendLimit = value
    }

    /**
     * @param value The name of the Amazon S3 bucket to receive daily SMS usage reports from Amazon SNS.
     */
    @JvmName("cecahudkebnbdntj")
    public suspend fun usageReportS3Bucket(`value`: Output<String>) {
        this.usageReportS3Bucket = value
    }

    /**
     * @param value A string, such as your business brand, that is displayed as the sender on the receiving device.
     */
    @JvmName("dkiaakynoxhkftcp")
    public suspend fun defaultSenderId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultSenderId = mapped
    }

    /**
     * @param value The type of SMS message that you will send by default. Possible values are: Promotional, Transactional
     */
    @JvmName("hvojupqtlqyjhega")
    public suspend fun defaultSmsType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultSmsType = mapped
    }

    /**
     * @param value The ARN of the IAM role that allows Amazon SNS to write logs about SMS deliveries in CloudWatch Logs.
     */
    @JvmName("jfplngkvjfvpwrnb")
    public suspend fun deliveryStatusIamRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deliveryStatusIamRoleArn = mapped
    }

    /**
     * @param value The percentage of successful SMS deliveries for which Amazon SNS will write logs in CloudWatch Logs. The value must be between 0 and 100.
     */
    @JvmName("kgybhohmkepbxanm")
    public suspend fun deliveryStatusSuccessSamplingRate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deliveryStatusSuccessSamplingRate = mapped
    }

    /**
     * @param value The maximum amount in USD that you are willing to spend each month to send SMS messages.
     */
    @JvmName("bymnnwvkegxbouxc")
    public suspend fun monthlySpendLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monthlySpendLimit = mapped
    }

    /**
     * @param value The name of the Amazon S3 bucket to receive daily SMS usage reports from Amazon SNS.
     */
    @JvmName("lwcucrfoqxmwdiiq")
    public suspend fun usageReportS3Bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usageReportS3Bucket = mapped
    }

    internal fun build(): SmsPreferencesArgs = SmsPreferencesArgs(
        defaultSenderId = defaultSenderId,
        defaultSmsType = defaultSmsType,
        deliveryStatusIamRoleArn = deliveryStatusIamRoleArn,
        deliveryStatusSuccessSamplingRate = deliveryStatusSuccessSamplingRate,
        monthlySpendLimit = monthlySpendLimit,
        usageReportS3Bucket = usageReportS3Bucket,
    )
}
