@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sns.kotlin

import com.pulumi.aws.sns.SnsFunctions.getTopicPlain
import com.pulumi.aws.sns.kotlin.inputs.GetTopicPlainArgs
import com.pulumi.aws.sns.kotlin.inputs.GetTopicPlainArgsBuilder
import com.pulumi.aws.sns.kotlin.outputs.GetTopicResult
import com.pulumi.aws.sns.kotlin.outputs.GetTopicResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object SnsFunctions {
    /**
     * Use this data source to get the ARN of a topic in AWS Simple Notification
     * Service (SNS). By using this data source, you can reference SNS topics
     * without having to hard code the ARNs as input.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.sns.SnsFunctions;
     * import com.pulumi.aws.sns.inputs.GetTopicArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = SnsFunctions.getTopic(GetTopicArgs.builder()
     *             .name("an_example_topic")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getTopic.
     * @return A collection of values returned by getTopic.
     */
    public suspend fun getTopic(argument: GetTopicPlainArgs): GetTopicResult =
        toKotlin(getTopicPlain(argument.toJava()).await())

    /**
     * @see [getTopic].
     * @param name Friendly name of the topic to match.
     * @return A collection of values returned by getTopic.
     */
    public suspend fun getTopic(name: String): GetTopicResult {
        val argument = GetTopicPlainArgs(
            name = name,
        )
        return toKotlin(getTopicPlain(argument.toJava()).await())
    }

    /**
     * @see [getTopic].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;sns&#46;kotlin&#46;inputs&#46;GetTopicPlainArgs].
     * @return A collection of values returned by getTopic.
     */
    public suspend fun getTopic(argument: suspend GetTopicPlainArgsBuilder.() -> Unit):
        GetTopicResult {
        val builder = GetTopicPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getTopicPlain(builtArgument.toJava()).await())
    }
}
