@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sns.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Topic].
 */
@PulumiTagMarker
public class TopicResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TopicArgs = TopicArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TopicArgsBuilder.() -> Unit) {
        val builder = TopicArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Topic {
        val builtJavaResource = com.pulumi.aws.sns.Topic(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Topic(builtJavaResource)
    }
}

/**
 * Provides an SNS topic resource
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sns.Topic;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var userUpdates = new Topic("userUpdates");
 *     }
 * }
 * ```
 * ## Example with Delivery Policy
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const userUpdates = new aws.sns.Topic("userUpdates", {deliveryPolicy: `{
 *   "http": {
 *     "defaultHealthyRetryPolicy": {
 *       "minDelayTarget": 20,
 *       "maxDelayTarget": 20,
 *       "numRetries": 3,
 *       "numMaxDelayRetries": 0,
 *       "numNoDelayRetries": 0,
 *       "numMinDelayRetries": 0,
 *       "backoffFunction": "linear"
 *     },
 *     "disableSubscriptionOverrides": false,
 *     "defaultThrottlePolicy": {
 *       "maxReceivesPerSecond": 1
 *     }
 *   }
 * }
 * `});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * user_updates = aws.sns.Topic("userUpdates", delivery_policy="""{
 *   "http": {
 *     "defaultHealthyRetryPolicy": {
 *       "minDelayTarget": 20,
 *       "maxDelayTarget": 20,
 *       "numRetries": 3,
 *       "numMaxDelayRetries": 0,
 *       "numNoDelayRetries": 0,
 *       "numMinDelayRetries": 0,
 *       "backoffFunction": "linear"
 *     },
 *     "disableSubscriptionOverrides": false,
 *     "defaultThrottlePolicy": {
 *       "maxReceivesPerSecond": 1
 *     }
 *   }
 * }
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var userUpdates = new Aws.Sns.Topic("userUpdates", new()
 *     {
 *         DeliveryPolicy = @"{
 *   ""http"": {
 *     ""defaultHealthyRetryPolicy"": {
 *       ""minDelayTarget"": 20,
 *       ""maxDelayTarget"": 20,
 *       ""numRetries"": 3,
 *       ""numMaxDelayRetries"": 0,
 *       ""numNoDelayRetries"": 0,
 *       ""numMinDelayRetries"": 0,
 *       ""backoffFunction"": ""linear""
 *     },
 *     ""disableSubscriptionOverrides"": false,
 *     ""defaultThrottlePolicy"": {
 *       ""maxReceivesPerSecond"": 1
 *     }
 *   }
 * }
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sns.NewTopic(ctx, "userUpdates", &sns.TopicArgs{
 * 			DeliveryPolicy: pulumi.String(`{
 *   "http": {
 *     "defaultHealthyRetryPolicy": {
 *       "minDelayTarget": 20,
 *       "maxDelayTarget": 20,
 *       "numRetries": 3,
 *       "numMaxDelayRetries": 0,
 *       "numNoDelayRetries": 0,
 *       "numMinDelayRetries": 0,
 *       "backoffFunction": "linear"
 *     },
 *     "disableSubscriptionOverrides": false,
 *     "defaultThrottlePolicy": {
 *       "maxReceivesPerSecond": 1
 *     }
 *   }
 * }
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.sns.TopicArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var userUpdates = new Topic("userUpdates", TopicArgs.builder()
 *             .deliveryPolicy("""
 * {
 *   "http": {
 *     "defaultHealthyRetryPolicy": {
 *       "minDelayTarget": 20,
 *       "maxDelayTarget": 20,
 *       "numRetries": 3,
 *       "numMaxDelayRetries": 0,
 *       "numNoDelayRetries": 0,
 *       "numMinDelayRetries": 0,
 *       "backoffFunction": "linear"
 *     },
 *     "disableSubscriptionOverrides": false,
 *     "defaultThrottlePolicy": {
 *       "maxReceivesPerSecond": 1
 *     }
 *   }
 * }
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   userUpdates:
 *     type: aws:sns:Topic
 *     properties:
 *       deliveryPolicy: |+
 *         {
 *           "http": {
 *             "defaultHealthyRetryPolicy": {
 *               "minDelayTarget": 20,
 *               "maxDelayTarget": 20,
 *               "numRetries": 3,
 *               "numMaxDelayRetries": 0,
 *               "numNoDelayRetries": 0,
 *               "numMinDelayRetries": 0,
 *               "backoffFunction": "linear"
 *             },
 *             "disableSubscriptionOverrides": false,
 *             "defaultThrottlePolicy": {
 *               "maxReceivesPerSecond": 1
 *             }
 *           }
 *         }
 * ```
 * ## Example with Server-side encryption (SSE)
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const userUpdates = new aws.sns.Topic("userUpdates", {kmsMasterKeyId: "alias/aws/sns"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * user_updates = aws.sns.Topic("userUpdates", kms_master_key_id="alias/aws/sns")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var userUpdates = new Aws.Sns.Topic("userUpdates", new()
 *     {
 *         KmsMasterKeyId = "alias/aws/sns",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sns.NewTopic(ctx, "userUpdates", &sns.TopicArgs{
 * 			KmsMasterKeyId: pulumi.String("alias/aws/sns"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.sns.TopicArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var userUpdates = new Topic("userUpdates", TopicArgs.builder()
 *             .kmsMasterKeyId("alias/aws/sns")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   userUpdates:
 *     type: aws:sns:Topic
 *     properties:
 *       kmsMasterKeyId: alias/aws/sns
 * ```
 * ## Example with First-In-First-Out (FIFO)
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const userUpdates = new aws.sns.Topic("userUpdates", {
 *     contentBasedDeduplication: true,
 *     fifoTopic: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * user_updates = aws.sns.Topic("userUpdates",
 *     content_based_deduplication=True,
 *     fifo_topic=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var userUpdates = new Aws.Sns.Topic("userUpdates", new()
 *     {
 *         ContentBasedDeduplication = true,
 *         FifoTopic = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sns.NewTopic(ctx, "userUpdates", &sns.TopicArgs{
 * 			ContentBasedDeduplication: pulumi.Bool(true),
 * 			FifoTopic:                 pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.sns.TopicArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var userUpdates = new Topic("userUpdates", TopicArgs.builder()
 *             .contentBasedDeduplication(true)
 *             .fifoTopic(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   userUpdates:
 *     type: aws:sns:Topic
 *     properties:
 *       contentBasedDeduplication: true
 *       fifoTopic: true
 * ```
 * ## Message Delivery Status Arguments
 * The `<endpoint>_success_feedback_role_arn` and `<endpoint>_failure_feedback_role_arn` arguments are used to give Amazon SNS write access to use CloudWatch Logs on your behalf. The `<endpoint>_success_feedback_sample_rate` argument is for specifying the sample rate percentage (0-100) of successfully delivered messages. After you configure the  `<endpoint>_failure_feedback_role_arn` argument, then all failed message deliveries generate CloudWatch Logs.
 * ## Import
 * Using `pulumi import`, import SNS Topics using the topic `arn`. For example:
 * ```sh
 *  $ pulumi import aws:sns/topic:Topic user_updates arn:aws:sns:us-west-2:0123456789012:my-topic
 * ```
 *
 */
public class Topic internal constructor(
    override val javaResource: com.pulumi.aws.sns.Topic,
) : KotlinCustomResource(javaResource, TopicMapper) {
    /**
     * IAM role for failure feedback
     */
    public val applicationFailureFeedbackRoleArn: Output<String>?
        get() = javaResource.applicationFailureFeedbackRoleArn().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * The IAM role permitted to receive success feedback for this topic
     */
    public val applicationSuccessFeedbackRoleArn: Output<String>?
        get() = javaResource.applicationSuccessFeedbackRoleArn().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * Percentage of success to sample
     */
    public val applicationSuccessFeedbackSampleRate: Output<Int>?
        get() = javaResource.applicationSuccessFeedbackSampleRate().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * The message archive policy for FIFO topics. More details in the [AWS documentation](https://docs.aws.amazon.com/sns/latest/dg/message-archiving-and-replay-topic-owner.html).
     */
    public val archivePolicy: Output<String>?
        get() = javaResource.archivePolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ARN of the SNS topic, as a more obvious property (clone of id)
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The oldest timestamp at which a FIFO topic subscriber can start a replay.
     */
    public val beginningArchiveTime: Output<String>
        get() = javaResource.beginningArchiveTime().applyValue({ args0 -> args0 })

    /**
     * Enables content-based deduplication for FIFO topics. For more information, see the [related documentation](https://docs.aws.amazon.com/sns/latest/dg/fifo-message-dedup.html)
     */
    public val contentBasedDeduplication: Output<Boolean>?
        get() = javaResource.contentBasedDeduplication().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The SNS delivery policy. More details in the [AWS documentation](https://docs.aws.amazon.com/sns/latest/dg/DeliveryPolicies.html).
     */
    public val deliveryPolicy: Output<String>?
        get() = javaResource.deliveryPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The display name for the topic
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Boolean indicating whether or not to create a FIFO (first-in-first-out) topic (default is `false`).
     */
    public val fifoTopic: Output<Boolean>?
        get() = javaResource.fifoTopic().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * IAM role for failure feedback
     */
    public val firehoseFailureFeedbackRoleArn: Output<String>?
        get() = javaResource.firehoseFailureFeedbackRoleArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The IAM role permitted to receive success feedback for this topic
     */
    public val firehoseSuccessFeedbackRoleArn: Output<String>?
        get() = javaResource.firehoseSuccessFeedbackRoleArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Percentage of success to sample
     */
    public val firehoseSuccessFeedbackSampleRate: Output<Int>?
        get() = javaResource.firehoseSuccessFeedbackSampleRate().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * IAM role for failure feedback
     */
    public val httpFailureFeedbackRoleArn: Output<String>?
        get() = javaResource.httpFailureFeedbackRoleArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The IAM role permitted to receive success feedback for this topic
     */
    public val httpSuccessFeedbackRoleArn: Output<String>?
        get() = javaResource.httpSuccessFeedbackRoleArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Percentage of success to sample
     */
    public val httpSuccessFeedbackSampleRate: Output<Int>?
        get() = javaResource.httpSuccessFeedbackSampleRate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of an AWS-managed customer master key (CMK) for Amazon SNS or a custom CMK. For more information, see [Key Terms](https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html#sse-key-terms)
     */
    public val kmsMasterKeyId: Output<String>?
        get() = javaResource.kmsMasterKeyId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * IAM role for failure feedback
     */
    public val lambdaFailureFeedbackRoleArn: Output<String>?
        get() = javaResource.lambdaFailureFeedbackRoleArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The IAM role permitted to receive success feedback for this topic
     */
    public val lambdaSuccessFeedbackRoleArn: Output<String>?
        get() = javaResource.lambdaSuccessFeedbackRoleArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Percentage of success to sample
     */
    public val lambdaSuccessFeedbackSampleRate: Output<Int>?
        get() = javaResource.lambdaSuccessFeedbackSampleRate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the topic. Topic names must be made up of only uppercase and lowercase ASCII letters, numbers, underscores, and hyphens, and must be between 1 and 256 characters long. For a FIFO (first-in-first-out) topic, the name must end with the `.fifo` suffix. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Creates a unique name beginning with the specified prefix. Conflicts with `name`
     */
    public val namePrefix: Output<String>
        get() = javaResource.namePrefix().applyValue({ args0 -> args0 })

    /**
     * The AWS Account ID of the SNS topic owner
     */
    public val owner: Output<String>
        get() = javaResource.owner().applyValue({ args0 -> args0 })

    /**
     * The fully-formed AWS policy as JSON.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })

    /**
     * If `SignatureVersion` should be [1 (SHA1) or 2 (SHA256)](https://docs.aws.amazon.com/sns/latest/dg/sns-verify-signature-of-message.html). The signature version corresponds to the hashing algorithm used while creating the signature of the notifications, subscription confirmations, or unsubscribe confirmation messages sent by Amazon SNS.
     */
    public val signatureVersion: Output<Int>
        get() = javaResource.signatureVersion().applyValue({ args0 -> args0 })

    /**
     * IAM role for failure feedback
     */
    public val sqsFailureFeedbackRoleArn: Output<String>?
        get() = javaResource.sqsFailureFeedbackRoleArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The IAM role permitted to receive success feedback for this topic
     */
    public val sqsSuccessFeedbackRoleArn: Output<String>?
        get() = javaResource.sqsSuccessFeedbackRoleArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Percentage of success to sample
     */
    public val sqsSuccessFeedbackSampleRate: Output<Int>?
        get() = javaResource.sqsSuccessFeedbackSampleRate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Tracing mode of an Amazon SNS topic. Valid values: `"PassThrough"`, `"Active"`.
     */
    public val tracingConfig: Output<String>
        get() = javaResource.tracingConfig().applyValue({ args0 -> args0 })
}

public object TopicMapper : ResourceMapper<Topic> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sns.Topic::class == javaResource::class

    override fun map(javaResource: Resource): Topic = Topic(javaResource as com.pulumi.aws.sns.Topic)
}

/**
 * @see [Topic].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Topic].
 */
public suspend fun topic(name: String, block: suspend TopicResourceBuilder.() -> Unit): Topic {
    val builder = TopicResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Topic].
 * @param name The _unique_ name of the resulting resource.
 */
public fun topic(name: String): Topic {
    val builder = TopicResourceBuilder()
    builder.name(name)
    return builder.build()
}
