@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sns.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [TopicPolicy].
 */
@PulumiTagMarker
public class TopicPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TopicPolicyArgs = TopicPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TopicPolicyArgsBuilder.() -> Unit) {
        val builder = TopicPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): TopicPolicy {
        val builtJavaResource = com.pulumi.aws.sns.TopicPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return TopicPolicy(builtJavaResource)
    }
}

/**
 * Provides an SNS topic policy resource
 * > **NOTE:** If a Principal is specified as just an AWS account ID rather than an ARN, AWS silently converts it to the ARN for the root user, causing future deployments to differ. To avoid this problem, just specify the full ARN, e.g. `arn:aws:iam::123456789012:root`
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.sns.TopicPolicy;
 * import com.pulumi.aws.sns.TopicPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Topic("test");
 *         final var snsTopicPolicy = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .policyId("__default_policy_ID")
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions(
 *                     "SNS:Subscribe",
 *                     "SNS:SetTopicAttributes",
 *                     "SNS:RemovePermission",
 *                     "SNS:Receive",
 *                     "SNS:Publish",
 *                     "SNS:ListSubscriptionsByTopic",
 *                     "SNS:GetTopicAttributes",
 *                     "SNS:DeleteTopic",
 *                     "SNS:AddPermission")
 *                 .conditions(GetPolicyDocumentStatementConditionArgs.builder()
 *                     .test("StringEquals")
 *                     .variable("AWS:SourceOwner")
 *                     .values(var_.account-id())
 *                     .build())
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("AWS")
 *                     .identifiers("*")
 *                     .build())
 *                 .resources(test.arn())
 *                 .sid("__default_statement_ID")
 *                 .build())
 *             .build());
 *         var default_ = new TopicPolicy("default", TopicPolicyArgs.builder()
 *             .arn(test.arn())
 *             .policy(snsTopicPolicy.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(snsTopicPolicy -> snsTopicPolicy.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SNS Topic Policy using the topic ARN. For example:
 * ```sh
 *  $ pulumi import aws:sns/topicPolicy:TopicPolicy user_updates arn:aws:sns:us-west-2:0123456789012:my-topic
 * ```
 *
 */
public class TopicPolicy internal constructor(
    override val javaResource: com.pulumi.aws.sns.TopicPolicy,
) : KotlinCustomResource(javaResource, TopicPolicyMapper) {
    /**
     * The ARN of the SNS topic
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The AWS Account ID of the SNS topic owner
     */
    public val owner: Output<String>
        get() = javaResource.owner().applyValue({ args0 -> args0 })

    /**
     * The fully-formed AWS policy as JSON.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })
}

public object TopicPolicyMapper : ResourceMapper<TopicPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sns.TopicPolicy::class == javaResource::class

    override fun map(javaResource: Resource): TopicPolicy = TopicPolicy(
        javaResource as
            com.pulumi.aws.sns.TopicPolicy,
    )
}

/**
 * @see [TopicPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TopicPolicy].
 */
public suspend fun topicPolicy(name: String, block: suspend TopicPolicyResourceBuilder.() -> Unit):
    TopicPolicy {
    val builder = TopicPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TopicPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun topicPolicy(name: String): TopicPolicy {
    val builder = TopicPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
