@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sns.kotlin

import com.pulumi.aws.sns.TopicPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an SNS topic policy resource
 * > **NOTE:** If a Principal is specified as just an AWS account ID rather than an ARN, AWS silently converts it to the ARN for the root user, causing future deployments to differ. To avoid this problem, just specify the full ARN, e.g. `arn:aws:iam::123456789012:root`
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.sns.TopicPolicy;
 * import com.pulumi.aws.sns.TopicPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Topic("test");
 *         final var snsTopicPolicy = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .policyId("__default_policy_ID")
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions(
 *                     "SNS:Subscribe",
 *                     "SNS:SetTopicAttributes",
 *                     "SNS:RemovePermission",
 *                     "SNS:Receive",
 *                     "SNS:Publish",
 *                     "SNS:ListSubscriptionsByTopic",
 *                     "SNS:GetTopicAttributes",
 *                     "SNS:DeleteTopic",
 *                     "SNS:AddPermission")
 *                 .conditions(GetPolicyDocumentStatementConditionArgs.builder()
 *                     .test("StringEquals")
 *                     .variable("AWS:SourceOwner")
 *                     .values(var_.account-id())
 *                     .build())
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("AWS")
 *                     .identifiers("*")
 *                     .build())
 *                 .resources(test.arn())
 *                 .sid("__default_statement_ID")
 *                 .build())
 *             .build());
 *         var default_ = new TopicPolicy("default", TopicPolicyArgs.builder()
 *             .arn(test.arn())
 *             .policy(snsTopicPolicy.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(snsTopicPolicy -> snsTopicPolicy.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SNS Topic Policy using the topic ARN. For example:
 * ```sh
 *  $ pulumi import aws:sns/topicPolicy:TopicPolicy user_updates arn:aws:sns:us-west-2:0123456789012:my-topic
 * ```
 * @property arn The ARN of the SNS topic
 * @property policy The fully-formed AWS policy as JSON.
 */
public data class TopicPolicyArgs(
    public val arn: Output<String>? = null,
    public val policy: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sns.TopicPolicyArgs> {
    override fun toJava(): com.pulumi.aws.sns.TopicPolicyArgs =
        com.pulumi.aws.sns.TopicPolicyArgs.builder()
            .arn(arn?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TopicPolicyArgs].
 */
@PulumiTagMarker
public class TopicPolicyArgsBuilder internal constructor() {
    private var arn: Output<String>? = null

    private var policy: Output<String>? = null

    /**
     * @param value The ARN of the SNS topic
     */
    @JvmName("rrxvrgdihpcoxmgi")
    public suspend fun arn(`value`: Output<String>) {
        this.arn = value
    }

    /**
     * @param value The fully-formed AWS policy as JSON.
     */
    @JvmName("uccflfaeufvlvelo")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value The ARN of the SNS topic
     */
    @JvmName("rbmoxjqlwekbnbpx")
    public suspend fun arn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arn = mapped
    }

    /**
     * @param value The fully-formed AWS policy as JSON.
     */
    @JvmName("oostygmdsjjmdqra")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    internal fun build(): TopicPolicyArgs = TopicPolicyArgs(
        arn = arn,
        policy = policy,
    )
}
